<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/searchprofile.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/descriptions.class.php");
require_once(dirname(__FILE__)."/../common/infoxml.class.php");

class NQLSearchProfile extends SusheeObject{
	var $depth;
	var $profile_at_depth;
	
}

class NQLSearchProfileResolver extends SusheeObject{
	var $profile_config;
	var $isReturn = false;
	function NQLSearchProfileResolver($profile_config){
		$this->profile_config = $profile_config;
	}
	
	function execute(){
		$this->logFunction('execute');
		$depth = $this->profile_config['depth'];
		$profile = $this->profile_config;
		$profile_at_depth = array();
		
		$this->getProfileArrayFromXML_chained($profile_at_depth,0,$profile);
		if($depth!==false){
			
			$profile_for_deps = $profile_at_depth[sizeof($profile_at_depth)-1];
			if($profile_for_deps['name']=='mini' && isset($profile_at_depth[sizeof($profile_at_depth)-2])){
				array_pop($profile_at_depth);
				$profile_for_deps = $profile_at_depth[sizeof($profile_at_depth)-1];
			}
			if ($depth==='all'){
				$profile_at_depth['all']=$profile_for_deps;
			}else{
				// copying the profile for every depth (for future more complex profiling)
				for($this_depth=sizeof($profile_at_depth);$this_depth<=$depth;$this_depth++){
					
					$profile_at_depth[$this_depth]=$profile_for_deps;
				}
			}
		}else
			$depth = sizeof($profile_at_depth);
		
		$search_profile = new NQLSearchProfile();
		$search_profile->profile_at_depth = $profile_at_depth;
		$search_profile->depth = $depth;
		return $search_profile;
	}
	
	function getPredefinedProfile($profile_name){
		$desc_profile = new DescriptionProfile();
		$skel_profile = array('name'=>$profile_name,'mode'=>'normal','get_owner'=>false,'get_modifier'=>false,'get_creator'=>false,'freelinks_config'=>array(),'get_info'=>true,'desc_profile'=>$desc_profile,'get_dependencies'=>false,'get_descriptions'=>false,'get_categories'=>false,'get_freelinks'=>false,'get_comments'=>false,'get_properties'=>false);

		switch($profile_name){
			case 'mailingMedias':
			case 'publication':
				$skel_profile['get_descriptions']=true;
				$skel_profile['get_categories']=true;
				$skel_profile['get_dependencies']=true;//mini!
				$skel_profile['dependencies_profile']=$this->getPredefinedProfile('mini');
				break;
			case 'mini':
				$skel_profile['profileFields_by_module'][1] 
					= new InfoProfile( 
	array('ID'=>true,'CREATORID'=>true,'MODIFIERID'=>true,'OWNERID'=>true,'GROUPID'=>true,'CREATIONDATE'=>true,'MODIFICATIONDATE'=>true,'CONTACTTYPE'=>true,'FIRSTNAME'=>true,'LASTNAME'=>true,'DENOMINATION'=>true,'CLIENTCODE'=>true,'EMAIL1'=>true,'TITLE'=>true,'ADDRESS'=>true,'POSTALCODE'=>true,'CITY'=>true,'STATEORPROVINCE'=>true,'COUNTRYID'=>true,'PHONE1'=>true,'MOBILEPHONE'=>true,'FAX'=>true,'PURPOSE'=>true,'BIRTHDAY'=>true,'GENDER'=>true,'PREVIEW'=>true,'WEBSITE'=>true,'LANGUAGEID'=>true) 
					);
				break;
			case 'complete':
				$skel_profile['get_descriptions']=true;
				$skel_profile['get_categories']=true;
				$skel_profile['get_dependencies']=true;//mini!
				$skel_profile['dependencies_profile']=$this->getPredefinedProfile('mini');
				$skel_profile['get_comments']=true;
				$skel_profile['get_freelinks']=true;//mini!
				$skel_profile['freelinks_config']=array('profile'=>array('profile_name'=>'mini'));
				break;
			case 'descriptions_only':
				$skel_profile['get_info']=false;
				$skel_profile['get_descriptions']=true;
				break;
			case 'empty':
				break;
			case 'mailing_publication':
				$skel_profile['get_descriptions']=true;
				$skel_profile['get_categories']=true;
				$skel_profile['get_dependencies']=true;//mini!
				$skel_profile['dependencies_profile']=$this->getPredefinedProfile('mini');
				$skel_profile['get_creator']=true;
				break;
			case 'mini_inbox':
				$skel_profile['profileFields_by_module'][20] = 
					new InfoProfile (
	array('ID'=>true,/*'CREATIONDATE'=>true,'MODIFICATIONDATE'=>true,*/'ACCOUNTID'=>true,'TYPE'=>true,'PRIORITY'=>true,'FROM'=>true,'TO'=>true,'SENDINGDATE'=>true,'RECEIVINGDATE'=>true,'ATTACHMENTS'=>true,'SUBJECT'=>true,'READ'=>true,'FLAG'=>true,'FOLDER'=>true,'TRASH'=>true,'JUNK'=>true,'DIRECTORYID'=>true) 
					);
				break;
			case 'mini_publication':
				$skel_profile['profileFields_by_module'][5] = 
					new InfoProfile ( 
						array('MEDIATYPE'=>true,'TEMPLATE'=>true,'PAGETOCALL'=>true) 
					);
				$skel_profile['get_descriptions']=true;
				$skel_profile['desc_profile']=new DescriptionProfile('label');
				break;
			default:
		}
		if($GLOBALS["php_request"]){
			$skel_profile['desc_profile']->setAccessMode(NECTIL_PUBLIC);
		}else{
			$skel_profile['desc_profile']->setAccessMode(NECTIL_OS);
		}
		if ($GLOBALS["php_request"] && isset($GLOBALS["NectilLanguage"]) && $GLOBALS['restrict_language']){
			$skel_profile['desc_profile']->setLanguageMode(NECTIL_UNI_LNG);
			$skel_profile['desc_profile']->setLanguage($GLOBALS["NectilLanguage"]);
		}else
			$skel_profile['desc_profile']->setLanguageMode(NECTIL_MULTI_LNG);
			
		if(isset($GLOBALS["priority_language"]) && $GLOBALS["priority_language"]!==false){
			$skel_profile['desc_profile']->setPriorLanguage($GLOBALS["priority_language"]);
		}
		return $skel_profile;
	}
	
	function getInfoProfileArray(&$profile_xml,$profile_path){
		$profile_fields = $profile_xml->match($profile_path."/*[@get!='false' or not(@get)]");
		$profile_array = array();
		if ( sizeof($profile_fields)!=0 ){
			foreach($profile_fields as $profile_fields_path){
				$profile_array[$profile_xml->nodeName($profile_fields_path)]=true;
			}
		}
		return $profile_array;
	}
	
	function getBasicProfileArrayFromXML($profile){
		
		if(isset($profile['profile_name']) && $profile['profile_name']!='')
			return $this->getPredefinedProfile($profile['profile_name']);

		$profile_path = $profile['profile_path'];
		$profile_xml = $profile['profile_xml'];
		
		$this->logFunction('getBasicProfileArrayFromXML'.$profile_path);
		
		if($profile_xml->nodename($profile_path)=='RETURN'){
			$this->isReturn = true;
		}
		// --- READ-ONLY ---
		$mode = $profile_xml->getData($profile_path.'/INFO[1]/@mode');
		if(!$mode)
			$mode = $profile_xml->getData($profile_path.'/@mode');
		if ( $profile_xml->match($profile_path.'/@profile')){
			$profile_name = $profile_xml->getData($profile_path.'/@profile');

			$named_profile = $this->getPredefinedProfile($profile_name);
			if($mode)
				$named_profile['mode'] = $mode;
			return $named_profile;
		}
		if(!$mode)
			$mode = 'normal';
		// --- INFO ---
		$get_info = $profile_xml->getData($profile_path.'/INFO[1]/@get');

		if($get_info==='false' ) $get_info=false;
		else{
			if($this->isReturn && !$profile_xml->match($profile_path.'/INFO[1]'))
				$get_info=false;
			else
				$get_info=true;
		}
		// attribute on INFO allowing to get the infos of the contact with CREATORID indicated in element
		$get_creator = $profile_xml->getData($profile_path.'/INFO[1]/@creator_info');
		if(!$get_creator){
			$get_creator = $profile_xml->getData($profile_path.'/INFO[1]/@creator-info');
		}
		if(!$get_creator){
			$get_creator = $profile_xml->exists($profile_path.'/INFO[1]/CREATORID/INFO');
		}
			
		// attribute on INFO allowing to get the infos of the contact with MODIFIERID indicated in element
		$get_modifier = $profile_xml->getData($profile_path.'/INFO[1]/@modifier_info');
		if(!$get_modifier){
			$get_modifier = $profile_xml->getData($profile_path.'/INFO[1]/@modifier-info');
		}
		if(!$get_modifier){
			$get_modifier = $profile_xml->exists($profile_path.'/INFO[1]/MODIFIERID/INFO');
		}
		
		// attribute on INFO allowing to get the infos of the contact with OWNERID indicated in element
		$get_owner = $profile_xml->getData($profile_path.'/INFO[1]/@owner_info');
		if(!$get_owner){
			$profile_xml->getData($profile_path.'/INFO[1]/@owner-info');
		}
		if(!$get_owner){
			$get_owner = $profile_xml->exists($profile_path.'/INFO[1]/OWNERID/INFO');
		}
		
		// attribute on INFO allowing to get supplementary info about the dates
		$get_weekdays = $profile_xml->getData($profile_path.'/INFO[1]/@weekdays')==='true';
		$get_timestamp = $profile_xml->getData($profile_path.'/INFO[1]/@timestamp')==='true';
		$get_ymd = $profile_xml->getData($profile_path.'/INFO[1]/@year-month-day')==='true';

		if ($get_info){
			$modules = new modules();
			foreach($modules->list as $moduleInfo){
				if($profile_xml->match($profile_path."/INFO[1]/*")){
					$info_profile = new InfoProfile( $this->getInfoProfileArray($profile_xml,$profile_path."/INFO[1]") );
				}else{
					$info_profile = new InfoProfile( false );
				}
				$info_profile->includeWeekday($get_weekdays);
				$info_profile->includeTimestamp($get_timestamp);
				$info_profile->includeYearMonthDay($get_ymd);
				$info_profile->includeCreatorInfo($get_creator);
				$info_profile->includeModifierInfo($get_modifier);
				$info_profile->includeOwnerInfo($get_owner);
				$profileFields_by_module[$moduleInfo->ID] = $info_profile;
			}
		}
		// --- DESCRIPTION ---
		$description_profile_path = $profile_path.'/DESCRIPTIONS[1]';

		$get_descriptions = $profile_xml->getData($description_profile_path.'/@get');
		$node_descriptions = $profile_xml->match($description_profile_path);
		if(!$node_descriptions){
			$description_profile_path = $profile_path.'/DESCRIPTION[1]';
			$node_descriptions = $profile_xml->match($description_profile_path);
		}else{
			if($profile_xml->match($description_profile_path.'/DESCRIPTION[1]'))
				$description_profile_path = $description_profile_path.'/DESCRIPTION[1]';
		}

		if( ($get_descriptions==='true' || ($node_descriptions && $get_descriptions===FALSE))) $get_descriptions=true;
		else $get_descriptions=false;
		$desc_profile = new DescriptionProfile();
		if($get_descriptions){
			// this is for all depth : no way to get different description profile at different depth
			$desc_profile_name = $profile_xml->getData($description_profile_path.'/@profile');
			if($desc_profile_name)
				$desc_profile = new DescriptionProfile($desc_profile_name);
			else
				$desc_profile = new DescriptionProfile();
			/* CALLER WANT TO KNOW WHICH OTHER LANGUAGES ARE AVAILABLE */
			$desc_stats = $profile_xml->getData($description_profile_path.'/@stats');
			$desc_profile->setLanguageAvailability($desc_stats==='true');
			
			/* CALLER WANT TO KNOW the weekdays */
			$desc_weekdays = $profile_xml->getData($description_profile_path.'/@weekdays');
			$desc_profile->setWeekdaysAvailability($desc_weekdays==='true');
			
			$desc_status = $profile_xml->getData($description_profile_path.'/@status');
			if($desc_status)
				$desc_profile->setStatusMode($desc_status);
			
			if($GLOBALS["php_request"]){
				$desc_profile->setAccessMode(NECTIL_PUBLIC);
			}else{
				$desc_profile->setAccessMode(NECTIL_OS);
			}
			
			/* CALLER WANT TO DISCARD THE ELEMENTS WHICH DONT HAVE A DESCRIPTION */
			$desc_discarding = $profile_xml->getData($description_profile_path.'/@discard-element-if');

			/* LOOKING WHICH FIELDS ARE WANTED IN THE RETURNED XML */
			$node_profile = $profile_xml->getElements($description_profile_path.'/*');
			if($node_profile){
				$desc_profile->reset();
				foreach($node_profile as $node){
					$nodename_profile = $node->nodeName();
					if($nodename_profile!='CUSTOM'){
						$desc_profile->activateNativeField($nodename_profile);
					}else{
						$desc_profile->activateNativeField($nodename_profile);
						$custom_nodes = $node->getElements('./*');
						foreach($custom_nodes as $custom){
							$desc_profile->activateCustomField($custom->nodeName());
						}
					}
					
				}
			}
			/* WHICH LANGUAGES MUST BE RETURNED */
			$desc_language = $profile_xml->getData($description_profile_path.'/@languageID');
			if (!$desc_language)
				$desc_language = $profile_xml->getData($description_profile_path.'/LANGUAGEID');
			if (!$desc_language)
				$desc_language='';
			if ($GLOBALS["php_request"] && isset($GLOBALS["NectilLanguage"]) && $GLOBALS['restrict_language'] && $desc_language=='')
				$desc_language = $GLOBALS["NectilLanguage"];
			if ($desc_language==='all')
				$desc_language='';
			
			if($desc_language!=''){
				$desc_profile->setLanguageMode(NECTIL_UNI_LNG);
				$desc_profile->setLanguage($desc_language);
			}else{
				$desc_profile->setLanguageMode(NECTIL_MULTI_LNG);
			}
			$desc_output = $profile_xml->getData($description_profile_path.'/@output');
			if (!$desc_output)
				$desc_output = 'html';
			if(isset($GLOBALS["priority_language"]) && $GLOBALS["priority_language"]!==false){
				$desc_profile->setPriorLanguage($GLOBALS["priority_language"]);
			}
			$desc_profile->setDestination($desc_output);
		}
		// --- CATEGORIES ---
		$get_categories = $profile_xml->getData($profile_path.'/CATEGORIES[1]/@get');
		$node_categories = $profile_xml->match($profile_path.'/CATEGORIES[1]');
		if( ($get_categories==='true'|| ($node_categories && $get_categories===FALSE))) $get_categories=true;
		else $get_categories=false;
		// --- COMMENTS ---
		$get_comments = $profile_xml->getData($profile_path.'/COMMENTS[1]/@get');
		$node_comments = $profile_xml->match($profile_path.'/COMMENTS[1]');
		if( ($get_comments==='true' || ($node_comments && $get_comments===FALSE))) $get_comments=true;
		else $get_comments=false;
		// --- DEPENDENCIES ---
		$get_dependencies = $profile_xml->getData($profile_path.'/DEPENDENCIES[1]/@get');
		$node_dependencies = $profile_xml->match($profile_path.'/DEPENDENCIES[1] | '.$profile_path.'/DEPENDENCY[1]');
		if( ($get_dependencies==='true' || ($node_dependencies && $get_dependencies===FALSE) )) $get_dependencies=true;
		else $get_dependencies=false;
		// --- FREELINKS ---
		$get_freelinks = $profile_xml->getData($profile_path.'/FREELINKS[1]/@get');
		$node_freelinks = $profile_xml->match($profile_path.'/FREELINKS[1]');
		if( ($get_freelinks==='true' || ($node_freelinks && $get_freelinks===FALSE))) $get_freelinks=true;
		else $get_freelinks=false;
		if($get_freelinks){
			$moduleTarget = $profile_xml->getData($profile_path.'/FREELINKS[1]/@module');
			$moduleTargetID = FALSE;
			if ($moduleTarget){
				$moduleTargetInfo=moduleInfo($moduleTarget);
				if(!$moduleTargetInfo->loaded)
					$moduleTargetInfo=false;
			}
			$freeOnly = ($profile_xml->getData($profile_path.'/FREELINKS[1]/@freeOnly')==='true');

			if ($profile_xml->match($profile_path.'/FREELINKS[1]/@profile') )
				$freelink_profile = array('profile_name'=>$profile_xml->getData($profile_path.'/FREELINKS[1]/@profile'));

			else if($profile_xml->match($profile_path.'/FREELINKS[1]/WITH[1]'))
				$freelink_profile = array('profile_xml'=>$profile_xml,'profile_path'=>$profile_path.'/FREELINKS[1]/WITH[1]');
			$freelinks_config = array('freeOnly'=>$freeOnly,'module'=>$moduleTargetInfo,'profile'=>$freelink_profile);


		}
		// --- PROPERTIES ---
		$get_properties = $profile_xml->getData($profile_path.'/PROPERTIES[1]/@get');
		$node_properties = $profile_xml->match($profile_path.'/PROPERTIES[1]');
		if( ($get_properties==='true' || ($node_properties && $get_properties===FALSE))) $get_properties=true;
		else $get_properties=false;

		$get_omnilinks = $profile_xml->exists($profile_path.'/OMNILINKS[1]');
		
		return array('mode'=>$mode,
					'get_owner'=>$get_owner,
					'get_modifier'=>$get_modifier,
					'get_creator'=>$get_creator,
					'get_weekdays'=>$get_weekdays,
					'freelinks_config'=>$freelinks_config,
					'get_info'=>$get_info,
					'desc_profile'=>$desc_profile,
					'desc_discarding'=>$desc_discarding,
					'profileFields_by_module'=>$profileFields_by_module,
					'get_dependencies'=>$get_dependencies,
					'get_descriptions'=>$get_descriptions,
					'get_categories'=>$get_categories,
					'get_freelinks'=>$get_freelinks,
					'get_comments'=>$get_comments,
					'get_properties'=>$get_properties,
					'get_omnilinks'=>$get_omnilinks,
					// keeping in the resolved form  a reference to the original source (is useul for omnilinks handling)
					'path'=>$profile_path,
					'xml'=>$profile_xml
					);
	}
	function getProfileArrayFromXML_chained(&$profile_at_depth,$depth,$profile){
		
		
		$profile_path = $profile['profile_path'];
		$profile_xml = $profile['profile_xml'];
		
		$this->logFunction('getProfileArrayFromXML_chained '.$profile_path);
		
		$basic_array = $this->getBasicProfileArrayFromXML($profile);
		$get_dependencies = $basic_array['get_dependencies'];
		$profile_at_depth[$depth]=$basic_array;
		$depTypes_by_module = false;
		if ($get_dependencies){
			//checking there are specific dependencies asked
			$specific_deps_array = array();
			if(is_object($profile_xml)){
				$specific_deps_array = $profile_xml->match($profile_path.'/DEPENDENCIES[1]/DEPENDENCY | '.$profile_path.'/DEPENDENCY');
			}
				
			if (sizeof($specific_deps_array)>0){
				$depTypes_by_module = array();
				foreach($specific_deps_array as $path){
					$depTypeName = $profile_xml->getData($path."/@type");
					$get_dependency = $profile_xml->getData($path.'/@get');
					if( $get_dependency!=='false' ){
						$depType = depType($depTypeName);
						if ($depType->loaded){
							$dep_profile = false;
							$profile_name = $profile_xml->getData($path.'/@profile');
							if(!$profile_name)
								$profile_name = $profile_xml->getData($path.'/WITH[1]/@profile');
							if($profile_name){
								$profile_at_depth[$depth+1] =  $this->getBasicProfileArrayFromXML(array('profile_name'=>$profile_name));
							}else if($profile_xml->match($path.'/WITH[1]/*')){
								$dep_profile = $this->getProfileArrayFromXML_chained($profile_at_depth,$depth+1,array('profile_path'=>$path.'/WITH[1]','profile_xml'=>$profile_xml));
							}else if($profile_xml->match($path.'/*')){
								$dep_profile = $this->getProfileArrayFromXML_chained($profile_at_depth,$depth+1,array('profile_path'=>$path,'profile_xml'=>$profile_xml));
							}
							$dep_profile['boris'] = 'coucou moimême';
							$depTypes_by_module[$depType->ModuleOriginID][$depType->getID()]=array('depType'=>$depType,'profile'=>$dep_profile);
							// if module where starts the dependency (Origin) is an extension of another module, the dep can be returned for the inherited module also
							$moduleOrigin = $depType->getModuleOrigin();
							if($moduleOrigin->isExtension()){
								$nativeModule = $moduleOrigin->getParentModule();
								$depTypes_by_module[$nativeModule->getID()][$depType->getID()]=array('depType'=>$depType,'profile'=>$dep_profile);
							}else{
								$sql = 'SELECT `ID` FROM `modules` WHERE `Extends` = "'.$moduleOrigin->getName().'";';
								$db_conn = db_connect();
								$rs = $db_conn->execute($sql);
								while($row = $rs->fetchRow()){
									$depTypes_by_module[$row['ID']][$depType->getID()]=array('depType'=>$depType,'profile'=>$dep_profile);
								}
							}
							
							
						}
					}
				}
			}else{
				$profile_name = false;
				if(is_object($profile_xml))
					$profile_name = $profile_xml->getData($profile_path.'/DEPENDENCIES[1]/WITH[1]/@profile');	
				if($profile_name)
					$profile_at_depth[$depth+1] = $this->getBasicProfileArrayFromXML(array('profile_name'=>$profile_name));
				else if(is_object($profile_xml) && $profile_xml->match($profile_path.'/DEPENDENCIES[1]/WITH[1]/*'))
					$this->getProfileArrayFromXML_chained($profile_at_depth,$depth+1,array('profile_path'=>$profile_path.'/DEPENDENCIES[1]/WITH[1]','profile_xml'=>$profile_xml));
				else if(is_array($basic_array['dependencies_profile']))
					$profile_at_depth[$depth+1]=$basic_array['dependencies_profile'];
				else if(is_object($profile_xml) && $profile_xml->match($profile_path.'/DEPENDENCIES[1]/*'))
					$this->getProfileArrayFromXML_chained($profile_at_depth,$depth+1,array('profile_path'=>$profile_path.'/DEPENDENCIES[1]','profile_xml'=>$profile_xml));
				else
					$profile_at_depth[$depth+1]=$basic_array;
			}
		}
		
		$profile_at_depth[$depth]['depTypes_by_module']=$depTypes_by_module;
		$this->logFunction('depTypes_by_module profile '.$depTypes_by_module[1][28]['profile']);
		
		return $profile_at_depth[$depth];

	}
	function getProfileArrayFromXML_simple($profile){
		$this->logFunction('getProfileArrayFromXML_simple');
		$basic_array = $this->getBasicProfileArrayFromXML($profile);
		$profile_path = $profile['profile_path'];
		$profile_xml = $profile['profile_xml'];
		$get_dependencies = $basic_array['get_dependencies'];
		$depTypes_by_module = false;
		if ($get_dependencies){
			//checking there are specific dependencies asked
			$specific_deps_array = array();
			if(is_object($profile_xml))
				$specific_deps_array = $profile_xml->match($profile_path.'/DEPENDENCIES[1]/DEPENDENCY | '.$profile_path.'/DEPENDENCY');
			if (sizeof($specific_deps_array)>0)
				$depTypes_by_module = array();
			foreach($specific_deps_array as $path){
				$depTypeName = $profile_xml->getData($path."/@type");
				$get_dependency = $profile_xml->getData($path.'/@get');
				if( $get_dependency!=='false' ){
					$depType = depType($depTypeName);
					if ($depType->loaded){
						$depTypes_by_module[$depType->ModuleOriginID][$depType->ID]=array('depType'=>$depType,'profile'=>false);
						// if module where starts the dependency (Origin) is an extension of another module, the dep can be returned for the inherited module also
						$moduleOrigin = $depType->getModuleOrigin();
						if($moduleOrigin->isExtension()){
							$nativeModule = $moduleOrigin->getParentModule();
							$depTypes_by_module[$nativeModule->getID()][$depType->ID]=array('depType'=>$depType,'profile'=>false);
						}
					}
				}
			}
		}
		$basic_array['depTypes_by_module']=$depTypes_by_module;
		return $basic_array;
	}
}



?>