<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_delete.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/descriptions.inc.php');

function file_delete($queryname,$action,$target){
	
	global $directoryRoot;
	$target = transformPath(unhtmlentities($target));
	
	$right =  getPathSecurityRight($target);
	if ($right!=="W")
		return generateMsgXML(1,"Not authorized to delete this file.",0,'',$queryname);
		//die( xml_msg("1","-1","-1","Not authorized to delete this file."));
	
	$finalname = $target;
	
	$delete="put there the only file name (without directories)";
	
	//security and prerequisities
	$path_array= explode("/",$finalname);
	// Ok2Edit
	if (hidecheck($delete)) {
		/* delete the file or directory */
		if(is_dir($directoryRoot.$finalname)) {
			if($action=="recdelete"){
				$is_used = isFileUsed($finalname);
				if($is_used){
					if (is_object($is_used['moduleInfo']) && $is_used['moduleInfo']->loaded)
						return generateMsgXML(1,"Permission denied, directory is used in ".$is_used['moduleInfo']->name." '".$is_used['denomination']."' (ID:".$is_used['element']['ID'].")",0,$is_used['element']['ID'],$queryname);
					else
						return generateMsgXML(1,"Permission denied, directory is used in database.",0,'',$queryname);
				}
				//kill everything
				$killed = killDirectory($directoryRoot.$finalname,TRUE);
				if (!$killed)
					return generateMsgXML(1,"Some files are used in the database, they have been kept. The others have been deleted.",0,'',$queryname);
					//die( xml_msg("1","-1","-1","Some files are used in the database, they have been kept. The others have been deleted."));
			}else{
				if(isDirEmpty($directoryRoot.$finalname)){
					killDirectory($directoryRoot.$finalname);
				}else{
					$str = "<CONFIRM>recursive delete ?</CONFIRM>";
					return generateMsgXML(0,$str,0,'',$queryname);
					//die( xml_msg("0","-1","-1",$str));
				}
			}
			return generateMsgXML(0,"Directory:".retransformPath($finalname)." successfully removed!",0,'',$queryname);
			//die (xml_msg("0",$userID,$sessionID,"Directory:".retransformPath($finalname)." successfully removed!"));
		} else {
			
			//check if fileName is in DB (Description)
			//require_once("../common/services.inc.php");
			$is_used = isFileUsed($finalname);
			if($is_used){
				if (is_object($is_used['moduleInfo']) && $is_used['moduleInfo']->loaded)
					return generateMsgXML(1,"Permission denied, file is used in ".$is_used['moduleInfo']->name." '".$is_used['denomination']."' (ID:".$is_used['element']['ID'].")",0,$is_used['element']['ID'],$queryname);
					//die( xml_msg("1","-1","-1","Permission denied, file is used in ".$is_used['moduleInfo']->name." '".$is_used['denomination']."' (ID:".$is_used['element']['ID'].")"));
				else
					return generateMsgXML(1,"Permission denied, file is used in database.",0,'',$queryname);
					//die( xml_msg("1","-1","-1","Permission denied, file is used in database."));
			}
			if (file_exists($directoryRoot.$finalname)){ 
				if(unlink($directoryRoot.$finalname))
					return generateMsgXML(0,"File: ".retransformPath($finalname)." successfully deleted!",0,'',$queryname);
					//die (xml_msg("0",$userID,$sessionID,"File: ".retransformPath($finalname)." successfully deleted!"));
				else
					return generateMsgXML(1,"Permission denied, contact your Nectil administrator",0,'',$queryname);
					//die( xml_msg("1","-1","-1","Permission denied, contact your Nectil administrator"));
			  }else{
				  $str = "File: ".retransformPath($finalname)." doesn't exist.";
				  return generateMsgXML(1,$str,0,'',$queryname);
				  //die( xml_msg("1","-1","-1",$str));
			  }
		}
	} else {
		$str = "Deleting file:".retransformPath($finalname)." is a BLOCKED action.";
		return generateMsgXML(1,$str,0,'',$queryname);
		//die( xml_msg("1","-1","-1",$str)); 
	}
}
?>