<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_rename.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
// use $target
function file_rename($queryname,$action,$target,$target2){
	
	$target = transformPath(unhtmlentities($target));
	$target2 = transformPath(unhtmlentities($target2));
	
	$right =  getPathSecurityRight($target);
	if ($right===0)
		return generateMsgXML(1,"Not authorized to rename this file.",0,'',$queryname);
	$right =  getPathSecurityRight($target2);
	if ($right!=="W")
		return generateMsgXML(1,"Not authorized to rename like this.",0,'',$queryname);
	global $directoryRoot;
	global $BlockedExt;
	global $directoryCHMOD;
	$sourcename = $target;
	$targetname = $target2;
	
	$nname=BaseFilename($targetname);
	$oldname=basename($directoryRoot.$sourcename);
	
	// Change name of existing file Okay?
	$ext = getFileExt($target2);
	if(in_array($ext,$BlockedExt))
		return generateMsgXML(1,"Not authorized to rename this file : extension forbidden.",0,'',$queryname);
	// Modify this file okay?
	if (hidecheck($oldname)) { $go1=1; }
	// Is New name Okay?
	if (hidecheck($nname)) { $go2=1; }
	if(strpos($nname,' ')!==false && (getServerOS()=='windows'))
		return generateMsgXML(1,"Not authorized to rename this file : no white space is authorized in the filename.",0,'',$queryname);
	if ($go1+$go2==2) {
		if (file_exists($directoryRoot.$pathExt."$sourcename")){
			require_once(dirname(__FILE__)."/../common/services.inc.php");
			if (is_dir($directoryRoot.$pathExt."$sourcename")&& substr($sourcename,-1)!="/"){
				$sourcename.="/";
				if (substr($targetname,-1)!="/")
					$targetname.="/";
			}
			changeUsedFiles($sourcename,$targetname);
			$renamed = rename ($directoryRoot.$sourcename, $directoryRoot.$targetname);
			if($renamed)
				return generateMsgXML(0,retransformPath($sourcename)." successfully renamed!",0,'',$queryname);
			else
				return generateMsgXML(1,"Rename failed, contact your Nectil administrator",0,'',$queryname);
		}else{
			return generateMsgXML(1,"File doesn't exist : try to refresh the parent directory.",0,'',$queryname);
		}
	}else{
		if ($go1==0) {
			return generateMsgXML(1,"The file:".retransformPath($sourcename)." has been blocked for this action, contact your Nectil administrator",0,'',$queryname);
		}else{
			return generateMsgXML(1,"The file:".retransformPath($targetname)." has been blocked for this action, contact your Nectil administrator",0,'',$queryname);
		}
	}
}
?>