<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_unzip.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../file/file_functions.inc.php");
require_once(dirname(__FILE__)."/../file/file_config.inc.php");
//require_once(dirname(__FILE__)."/../file/zip/pclzip.lib.php");
function file_unzip($queryname,$action,$target){
	$target = transformPath($target);
	global $directoryRoot;
	//check if target exist
	if (isset($target)){
		//check security for this target 
		$right =  getPathSecurityRight($target);
		
		if($right !=="W"){
			return generateMsgXML(1,"Access to this directory refused",0,'',$queryname);
			//die(xml_msg(1,0,0,"Access to this directory refused"));
		}
		
		if(!hidecheck($target)){
			return generateMsgXML(1,"This file is blocked.",0,'',$queryname);
			//die(xml_msg(1,0,0,"This file is blocked."));
		}
		
		$location = unhtmlentities($directoryRoot.$target);
		 
		if(file_exists($location)){
			$tmp_dir = realpath($directoryRoot."/tmp").'/'.date('YmdHis');
			makedir($tmp_dir);
			$unzipped = unzip($location,$tmp_dir);
			if ($unzipped){
				cleanFilenames_in($tmp_dir);
				copy_content($tmp_dir,dirname($location));
				killDirectory($tmp_dir);
				unlink($location);
				return generateMsgXML(0,"Unzipping successful.",0,'',$queryname);
				//die(xml_msg(0,0,0,"Unzipping successful."));
			}else
				return generateMsgXML(1,"Zipping of directory failed.",0,'',$queryname);
				//die(xml_msg(1,0,0,"Zipping of directory failed."));
		}else{
			return generateMsgXML(1,"File doesn't exist.",0,'',$queryname);
			//die(xml_msg(1,0,0,"File doesn't exist."));
		}
	}else{
		return generateMsgXML(1,"Target filename is missing",0,'',$queryname);
		//die(xml_msg(1,0,0,"Target filename is missing"));
	}
}
?>