<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/file/file_zip.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../file/file_functions.inc.php");
require_once(dirname(__FILE__)."/../file/file_config.inc.php");
//require_once(dirname(__FILE__)."/../file/zip/pclzip.lib.php");
function file_zip($queryname,$action,$target){
	$target = transformPath(unhtmlentities($target));
	global $directoryRoot;
	//check if target exist
	if (isset($target)){
		//check security for this target 
		$right =  getPathSecurityRight($target);
		
		if($right !=="W"){
			return generateMsgXML(1,"Access to this directory refused",0,'',$queryname);
			//die(xml_msg(1,0,0,"Access to this directory refused"));
		}
		
		if(!hidecheck($target)){
			return generateMsgXML(1,"This file is blocked.",0,'',$queryname);
			//die(xml_msg(1,0,0,"This file is blocked."));
		}
		
		$location = $directoryRoot.$target;
		 
		if(is_dir($location)){
			$is_used = isFileUsed($target);
			if($is_used){
				if (is_object($is_used['moduleInfo']) && $is_used['moduleInfo']->loaded)
					return generateMsgXML(1,"Permission denied, file is used in ".$is_used['moduleInfo']->name." '".$is_used['denomination']."' (ID:".$is_used['element']['ID'].")",0,'',$queryname);
					//die( xml_msg("1","-1","-1","Permission denied, the directory or one of its files is used in ".$is_used['moduleInfo']->name." '".$is_used['denomination']."'"));
				else
					return generateMsgXML(1,"Permission denied, file is used in database.",0,'',$queryname);
					//die( xml_msg("1","-1","-1","Permission denied, the directory or one of its files is used in database."));
			}
			$zipped = zip($location,simplify($location).".zip");
			if ($zipped){
				killDirectory($location);
				return generateMsgXML(0,"Zipping of directory successful.",0,'',$queryname);
				//die(xml_msg(0,0,0,"Zipping of directory successful."));
			}else
				return generateMsgXML(1,"Zipping of directory failed.",0,'',$queryname);
				//die(xml_msg(1,0,0,"Zipping of directory failed."));
		}else{
			require_once(dirname(__FILE__)."/../common/services.inc.php");
			$is_used = isFileUsed($target);
			if($is_used){
				if (is_object($is_used['moduleInfo']) && $is_used['moduleInfo']->loaded)
					return generateMsgXML(1,"Permission denied, file is used in ".$is_used['moduleInfo']->name." '".$is_used['denomination']."' (ID:".$is_used['element']['ID'].")",0,'',$queryname);
					//die( xml_msg("1","-1","-1","Permission denied, file is used in ".$is_used['moduleInfo']->name." '".$is_used['denomination']."'"));
				else
					return generateMsgXML(1,"Permission denied, file is used in database.",0,'',$queryname);
					//die( xml_msg("1","-1","-1","Permission denied, file is used in database."));
			}
			$zipped = zip($location,simplify($location).".zip");
			if ($zipped){
				unlink($location);
				return generateMsgXML(0,"Zipping of file successful.",0,'',$queryname);
				//die(xml_msg(0,0,0,"Zipping of file successful."));
			}else
				return generateMsgXML(1,"Zipping of file failed.",0,'',$queryname);
				//die(xml_msg(1,0,0,"Zipping of file failed."));
		}
	}else{
		return generateMsgXML(1,"Target filename is missing",0,'',$queryname);
		//die(xml_msg(1,"Target filename is missing"));
	}
}
?>