<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/clean_tmpfiles.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../common/file.class.php");

class TempFilesCleaner extends SusheeObject{
	
	
	function execute(){
		$this->logFunction('TempFilesCleaner.execute');
		set_time_limit(0);
		$folders = array();
		$folders[]= new Folder('/tmp/');
		$folders[]= new Folder('/cache/xsushee/');
		$folders[]= new Folder('/cache/html/');
		$folders[]= new Folder('/pdf/');
		$folders[]= new Folder('/confirm/');
		$folders[]= new Folder('/images/');
		
		foreach($folders as $folder){
			while($file = $folder->getNextFile()){
				if($file->isOld()){
					//$this->log('must delete '.$file->getCompletePath());
					if($file->isWritable()){
						$file->delete();
					}
				}else{
					//$this->log($file->getCompletePath().' is not old enough');
				}
			}
		}
	}
}

$cleaner = new TempFilesCleaner();
$cleaner->execute();

?>
