<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/confirmOperation.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/file.class.php');


class sushee_confirmOperation extends RetrieveOperation{
	
	function parse(){
		$this->elementID = $this->firstNode->getData("@ID");
		if(!$this->elementID){
			$this->setError("No operation ID was given. You must set an attribute called ID, which identifies which operation is to confirm.");
			return false;
		}
		return true;
	}
	
	function operate(){
		$file = new File('/confirm/subquery_'.$this->elementID.'.xml');
		if(!$file->exists()){
			$this->setError("This operation doesn't exist or was already confirmed and already executed. ");
			return false;
		}
		$subquery = $file->toString();
		$file->delete();
		$result = request($subquery,true,false,false,false,$GLOBALS["restrict_language"],$GLOBALS["priority_language"],$GLOBALS["php_request"],$GLOBALS["dev_request"]);
		$this->xml = $result;
		return true;
	}
	
}

?>