<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/createPDF.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
function createPDF($name,&$xml,$requestName,$current_path,$firstNode,$firstNodePath){
	
	$origin_xml = $xml->toString($firstNodePath.'/QUERY');
	$short_template = $xml->getData($firstNodePath.'/@template');
	if(!$short_template)
		return generateMsgXML(1,"You didn't indicate any template",0,false,$name);
	$template = $GLOBALS["nectil_dir"].$short_template;
	if(!file_exists($template))
		return generateMsgXML(1,"The template $short_template indicated doesn't exist",0,false,$name);
	
	$result = query($origin_xml,FALSE,TRUE,TRUE);
	//die($result);
	$filename = transform_to_pdf($result,$template,false);
	
	if($filename === false)
		$query_result = generateMsgXML(1,"Generation of PDF failed for unknown reason",0,false,$name);
	else{
		if(substr($filename,0,strlen($GLOBALS["directoryRoot"]))==$GLOBALS["directoryRoot"] )
			$filename = substr($filename,strlen($GLOBALS["directoryRoot"]));
		if ($name)
			$attributes.=" name='$name'";
		$external_file = $xml->getData($current_path.'/@fromFile');
		if($external_file)
			$attributes.=" fromFile='".$external_file."'";
		$query_result='<RESULTS'.$attributes.'>';
		$query_result.= '<PDF>'.$filename.'</PDF></RESULTS>';
	}
	return $query_result;
}
?>
