<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/createRTF.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/file.class.php');
require_once(dirname(__FILE__).'/../common/nql.class.php');
require_once(dirname(__FILE__).'/../common/pdf.class.php');

class sushee_createRTF extends RetrieveOperation{
	
	var $template = false;
	
	function parse(){
		
		$this->template = $this->firstNode->getData('@template');
		if(!$this->template){
			$this->setError("You didn't mention any template");
			return false;
		}
		$template_file = new KernelFile($this->template);
		if(!$template_file->exists()){
			$this->setError("The mentioned template `".$this->template."` doesn't exist");
			return false;
		}
		return true;
	}
	
	function operate(){
		// executing the request
		$shell = new Sushee_Shell(false);
		$shell->addCommand($this->firstNode->toString('QUERY/*'));
		
		$response = $shell->execute();

		// generating the rtf
		$rtf_generator = new sushee_RTFGenerator();
		$template_file = new KernelFile($this->template);
		$rtf_generator->setTemplate($template_file->getCompletePath());
		$res = $rtf_generator->execute($response);
		// captured error
		if(!$res){
			$this->setError('Problem encountered while generating RTF : see debug.log for details');
			return false;
		}
		
		// controlling output
		$file = $rtf_generator->getFile();
		if(!$file->exists() || $file->getSize()==0){
			$this->setError('Problem encountered while generating RTF : see debug.log for details');
			return false;
		}
		$xml = '<RESULTS '.$this->getOperationAttributes().'>';
		$xml.='<RTF>'.$file->getPath().'</RTF>';
		$xml.='</RESULTS>';
		
		$this->setXML($xml);
		
		return true;
	}
	
}



?>