<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/createVCal.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/file.class.php');
require_once(dirname(__FILE__).'/../common/nql.class.php');

class createVCal extends RetrieveOperation{
	
	var $queryNode;
	
	function parse(){
		$this->queryNode = $this->firstNode->getElement('QUERY');
		return true;
	}
	
	function operate(){
		$nql = new NQL();
		$nql->addCommands(
			$this->queryNode->getElements('./*')
			);
		$nql->addCommand(
			'<SEARCH>
				<PREFS domain="Calendars"/>
			</SEARCH>');
		$nql->addCommand(
			'<GET name="visitor">
				<CONTACT ID="visitor"/>
				<RETURN><INFO><EMAIL1/></INFO></RETURN>
			</GET>');
		$templateFile = new KernelFile('/Kernel/templates/vcalendar.xsl');
		$vcal_str = $nql->transformToText($templateFile);
		
		$vcalFile = new TempFile();
		$vcalFile->setExtension('ics');
		
		$vcalFile->save($vcal_str);
		
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		$xml.=		'<VCALENDAR>'.$vcalFile->getPath().'</VCALENDAR>';
		$xml.='</RESULTS>';
		$this->setXML($xml);
		//$this->setXML($vcal_str);
		//$this->setXML($nql->getResponse());
		
		return true;
	}
}

?>