<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/deleteApplication.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/db_manip.class.php');
require_once(dirname(__FILE__).'/../common/namespace.class.php');
require_once(dirname(__FILE__).'/../common/application.class.php');

class deleteApplication extends NQLOperation{
	
	var $denomination;
	
	function parse(){
		$denomination = $this->firstNode->valueOf('DENOMINATION');
		if(!$denomination){
			$this->setError('No name was provided for the application to delete');
			return false;
		}
		$this->denomination = $denomination;
		return true;
	}
	
	function operate(){
		$application = new CustomApplication($this->denomination);
		$db_conn = db_connect();
		
		if(!$application->exists()){
			$this->setError('Application "'.$this->denomination.'" doesn\'t exist');
			return false;
		}
		if($application->isNative()){
			$this->setError('Application "'.$this->denomination.'"  is native and may not be deleted');
			return false;
		}
		
		
		
		$sql = 'DELETE FROM `applications` WHERE `ID`=\''.$application->getID().'\';';
		$this->logSQL($sql);
		$db_conn->Execute($sql);
		
		$namespace = $application->getNameSpace();
		if($namespace){
			$namespace->delete();
		}
		
		$this->setMsg('Application deleted');
		return true;
	}
}

?>