<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/deleteField.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../private/delete.inc.php');

class deleteField extends NQLOperation{
	
	function parse(){
		// taking the ID of the field to delete
		// kill on fields are only possible with the ID, WHERE is too dangerous, because it could modify too much on the database
		$this->fieldID = $this->firstNode->valueOf('@ID');
		if(!$this->fieldID){
			$this->setError('You didnt provide the ID of the field to delete');
			return false;
		}
		return true;
	}
	
	function operate(){
		// first getting back the former field informations in the database, in order to work in database
		$fieldModuleElt = new FieldModuleElement($this->fieldID);
		$fieldModuleElt->loadFields();
		
		// module from which is the field
		$moduleInfo = moduleInfo($fieldModuleElt->getField('Module'));
		// real field in Database
		$DBField = $moduleInfo->getField($fieldModuleElt->getField('FieldName'));
		
		if($DBField && $DBField->exists()){
			// verifying user doesnt try to delete an important field like ID, Activity, Searchtext, which are vital to the working of the module
			if($DBField->isMandatory()){
				$this->setError('This field cannot be deleted, its deletion would prevent the module from working.');
				return false;
			}
			$res = $DBField->delete();
			if(!$res){
				$this->setError($DBField->getError());
				return false;
			}
			if($DBField->exists()){
				$this->setError('Problem deleting the field from the table');
				return false;
			}
		}
		// forcing a KILL, to be sure the dependencies to the module will not prevent the delete to be done
		$killXML = new XML(
			'<KILL>
				<FIELD ID="'.$this->fieldID.'"/>
			</KILL>');
		$killNode = $killXML->getElement('/KILL');
		// letting the delete in fields table be done
		$delete = new deleteElement($this->getName(),$killNode);
		$delete->execute();
		$this->setMsg($delete->getMsg());
		
		$moduleInfo->clearInSession();
		
		return true;
	}
	
}

?>