<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/getTime.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/date.class.php');

/*

<GET>
	<TIME>date expression</TIME>
</GET>

date expressions can be : 

today
now
today+7 days
now+7 hours
today-1 months
this_month
etc ...

*/

class Sushee_getTime extends RetrieveOperation{
	
	function parse(){
		
		return true;
	}
	
	function operate(){
		$value = $this->firstNode->valueOf();
		if(!$value){
			$value = 'now';
		}
		$converter = new DateTimeKeywordConverter($value,'=');
		$date = new Date($converter->execute());
		
		$this->setXML('<RESULTS'.$this->getOperationAttributes().'><TIME>'.$date->getDateTime().'</TIME></RESULTS>');
		
		return true;
	}
	
}


?>