<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/getimage.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/image.class.php');
class getImage extends RetrieveOperation{
	
	var $image = false;
	
	function parse(){
		$path = $this->firstNode->valueOf('@path');
		$this->image = new Image($path);
		if(!$this->image->exists()){
			$this->setError('File '.$path.' doesn\'t exist');
			return false;
		}
		return true;
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		$xml.=		'<IMAGE path="'.$this->image->getPath().'" name="'.$this->image->getShortName().'"';
		if($this->image->getExtension()){
			$xml.=' ext=".'.$this->image->getExtension().'"';
		}
		$xml.='>';
		$xml.=		'<INFO>';
		$xml.=$this->image->getInfoXML();
		$xml.=		'</INFO>';
		$xml.=		'</IMAGE>';
		$xml.='</RESULTS>';
		$this->xml = $xml;
		return true;
	}
}
?>