<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/postMessage.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

class Sushee_PostMessage extends RetrieveOperation{
	
	function parse(){
		return true;
	}
	
	function operate(){
		$shell = new Sushee_Shell();
		
		if($this->firstNode->valueOf('WEBACCOUNT/@ID')){
			$accountIDs = ' ID="'.$this->firstNode->valueOf('WEBACCOUNT/@ID').'"';
		}
		
		$shell->addCommand(
			'<SEARCH>
				<WEBACCOUNT'.$accountIDs.'>
					<INFO>
						<OWNERID>visitor</OWNERID>
					</INFO>
					<INFO>
						<OWNERID op="!=">visitor</OWNERID>
						<PUBLIC>RW</PUBLIC>
					</INFO>
				</WEBACCOUNT>
				<RETURN>
					<INFO>
						<API/>
					</INFO>
				</RETURN>
			</SEARCH>');
			
		$shell->execute();
		
		$accounts = $shell->getElements('/RESPONSE/RESULTS/WEBACCOUNT');
		$text = $this->firstNode->valueOf('TEXT');
		foreach($accounts as $account){
			switch($account->valueOf('INFO/API')){
				case 'twitter':
					$shell->addCommand(
						'<GET name="'.$this->getName().'">
							<WEBSERVICE method="post" url="https://api.twitter.com/1/statuses/update.xml">
								<WEBACCOUNT ID="'.$account->valueOf('@ID').'"/>
									<PARAMS>
										<PARAM name="status">'.$text.'</PARAM>
									</PARAMS>
							</WEBSERVICE>
						</GET>');
			}
		}
		$shell->execute();
		$this->setXML($shell->copyOf('/RESPONSE/RESULTS'));
		
		return true;
	}
	
}



?>