<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/processMovie.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/movie.class.php');
class processMovie extends RetrieveOperation{
	var $source;
	function parse(){
		$source_path = $this->firstNode->valueOf('PATH');
		$this->source = new Movie($source_path);
		
		if(!$this->source->exists()){
			$this->setError("The source movie doesn't exist.");
			return false;
		}
		
		return true;
	}
	
	function operate(){
		$outputNodes = $this->firstNode->getElements('OUTPUT/*');
		$targets = array();
		foreach($outputNodes as $outputNode){
			$nodeName = $outputNode->nodeName();
			$target_path = $outputNode->valueOf('PATH');
			switch($nodeName){
				case 'MOVIE':
					$effects = new MovieEffects();
					$effects->setSource($this->source);
					$target = new Movie($target_path);
					$effects->setTarget($target);
					$effectsNodes = $outputNode->getElements('EFFECTS/*');
					$effects->parseXMLNodes($effectsNodes);
					$effects->execute();
					break;
				case 'IMAGE':
					$effects = new ImageMovieEffects();
					$effects->setSource($this->source);
					$target = new Image($target_path);
					$effects->setTarget($target);
					$effectsNodes = $outputNode->getElements('EFFECTS/*');
					$effects->parseXMLNodes($effectsNodes);
					$effects->execute();
					break;
				default:
			}
			if(!$target->exists()){
				$this->setError('Problem generating file `'.$target->getPath().'` : '.$effects->getMessage());
				return false;
			}else{
				$targets[]=$target;
			}
		}
		$xml = '<RESULTS'.$this->getOperationAttributes().'>';
		foreach($targets as $target){
			$xml.=$target->getXML();
		}
		$xml.= '</RESULTS>';
		$this->setXML($xml);
		return true;
	}
}

?>