<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/search.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__)."/../private/metaSearch.inc.php");
require_once(dirname(__FILE__)."/../common/nectil_user.class.php");




class SearchElement extends RetrieveOperation{
	function parse(){
		
		return true;
	}
	
	function operate(){
		$requestName = $this->operationNode->getNodename();
		$xml = $this->operationNode->getDocument();
		$current_path = $this->operationNode->getPath();
		$modulePath = $this->firstNode->getPath();
		$moduleName  = $this->firstNode->getNodename();
		$moduleInfo = moduleInfo($moduleName);
		$db_conn = db_connect();
		
		if(!$moduleInfo || !$moduleInfo->loaded){
			// no moduleerror of the user probably
			$this->setError('Module `'.$moduleName.'` could not be loaded');
			return false;
		}
		if(!$moduleInfo->getActionSecurity("SEARCH")){ // same security for GET
			$this->setError("You're not authorized to search elements in this module (".$moduleName.").");
			return false;
		}
		$query_result = '';
		//-----------------------------------
		// PREPROCESS
		//-----------------------------------
		$moduleInfo->preProcess('SEARCH',false,new XMLNode($xml,$current_path),$former_values,$new_values,$return_values);
		//-----------------------------------
		// SQL
		//-----------------------------------
		$sql='';
		$rs = getResultSet($moduleInfo,$xml,$current_path,$sql);
		if (is_string($rs))
			return $rs;
		if ((!$rs || get_class($rs)!='ADORecordSet_mysql') && $requestName!=='COUNT'){
			if(strlen($sql)<1024)
				$this->setError($db_conn->ErrorMsg().' '.$sql);
			else
				$this->setError($db_conn->ErrorMsg().'. Length of query:'.strlen($sql));
			return false;
		}else{
			//-----------------------------------
			// PROFILING
			//-----------------------------------
			$depth = false;
			$profile_path = $modulePath.'/WITH[1]';
			$isWith = $xml->match($profile_path);
			if(!$isWith){
				$profile_path = $current_path.'/RETURN[1]';
				$isWith = $xml->match($profile_path);
			}
			
			$profile = array('profile_xml'=>$xml,'profile_path'=>$profile_path);
			if ($isWith){
				if ($xml->match($profile_path.'/@depth') ){
					$possible_depth = $xml->getData($profile_path.'/@depth');
					if (is_numeric($possible_depth))
						$depth = (int)$possible_depth;
					else if($possible_depth=='all')
						$depth = 'all';
					else 
						$depth = 1;
				}
				if ($xml->getData($profile_path.'/@oneHit')==="true" && $rs->RecordCount()==1){
					$profile = array('profile_name'=>'complete');
				}
			}
			// first profile is outside the xml
			$outside_profile_ok = FALSE;
			if ($GLOBALS["dev_request"]===true && ( !$isWith || (!$xml->match($profile_path.'/@profile') && !$xml->match($profile_path.'/*[1]')) ) ){
				$profile = array('profile_name'=>'publication');
			}
			
			//-----------------------------------
			// SQL HANDLING
			//-----------------------------------
			if($requestName!=='COUNT'){
				if($this->operationNode->getAttribute('prototype')==='true'){
					require_once(dirname(__FILE__).'/../common/searchoutputmanager.proto.php');
					$manager = new Sushee_SearchOutputManager();
					$manager->setModule($moduleInfo->ID);
					$manager->setResultSet($rs); // the SQL result set
					$manager->setOperationnode(new XMLNode($xml,$current_path));
					
					$query_result = $manager->getXML();
				}else{
					$must_get_files = is_array($GLOBALS['used_Files']);
					$manager = new NQLSearchOutputManager();
					$manager->setModule($moduleInfo->ID);
					$manager->setResultSet($rs); // the SQL result set
					$manager->setOperationnode(new XMLNode($xml,$current_path));

					$manager->setProfileConfig($profile);
					$manager->setDepth($depth);
					if($must_get_files)
						$manager->setFilesCollect(true);
					$query_result = $manager->getXML();

					if($must_get_files)
						$GLOBALS['used_Files'] = $manager->getFiles();
				}
			}
		}
		//-----------------------------------
		// POSTPROCESS
		//-----------------------------------
		//$moduleInfo->postProcess('SEARCH',false,new XMLNode($xml,$current_path),$former_values,$new_values,$return_values);

		$attributes = $this->getOperationAttributes();
		
		
		if ($rs->result_page){
			$attributes.=' page="'.$rs->result_page.'"';
			$attributes.=' isLastPage="'.$rs->isLastPage.'"';
			$attributes.=' totalPages="'.$rs->totalPages.'"';
			$attributes.=' totalCount="'.$rs->totalCount.'"';
		}
		if($rs->packet){
			$attributes.=' page="'.$rs->packet.'"';
			$attributes.=' pages="'.$rs->total_packets.'"';
			$attributes.=' last-page="'.$rs->last_packet.'"';
			$attributes.=' hits="'.$rs->total_elements.'"';
		}else if($requestName!='COUNT'){
			$attributes.=' hits="'.$rs->total_elements.'"';
		}
		if($requestName=='COUNT'){
			$attributes.=' totalCount="'.$rs->totalCount.'"';
			if(!$rs->packet)
				$attributes.=' hits="'.$rs->totalCount.'"';
		}
		// adding the SQL if user is asking
		$user = new NectilUser();
		$userID = $user->getID();
		if($this->operationNode->getElement('/RETURN/SQL')){
			$query_result.='<SQL>'.encode_to_xml($sql).'</SQL>';
		}
		
		$this->xml = '<RESULTS'.$attributes.'>'.$query_result.'</RESULTS>';
		
		return true;
	}
}

?>
