<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/searchDeptype.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/dependencies.class.php');
require_once(dirname(__FILE__)."/../common/datas_structure.class.php");
require_once(dirname(__FILE__)."/../common/nectil_user.class.php");

class searchDepType extends RetrieveOperation{
	var $moduleOriginInfo = false;
	var $moduleTargetInfo = false;
	var $domain = false;
	var $temporal = false;
	var $ID = false;
	
	function parse(){
		// taking all deptypes starting from a given module
		$moduleOrigin = $this->firstNode->valueOf("/@from");
		if($moduleOrigin){
			$this->moduleOriginInfo = moduleInfo($moduleOrigin);
			if (!$this->moduleOriginInfo->loaded){
				$this->setError($this->moduleOriginInfo->getLastError());
				return false;
			}
		}
		// taking all deptypes arriving to a given module
		$moduleTarget = $this->firstNode->valueOf("/@to");
		if($moduleTarget){
			$this->moduleTargetInfo = moduleInfo($moduleTarget);
			if (!$this->moduleTargetInfo->loaded){
				$this->setError($this->moduleTargetInfo->getLastError());
				return false;
			}
		}
		
		$this->domain = $this->firstNode->valueOf("DOMAIN");
		$this->temporal = $this->firstNode->valueOf("TEMPORAL");
		// taking a deptype
		$this->ID = $this->firstNode->valueOf("@ID");
		return true;
	}
	
	
	
	function getCompleteDeps(){
		$depTypeSet = $this->getDeps();
		$made = array();
		// array to keep trace of which dependency we already have made : especially useful for two-way asymmetric dependency where we don't want to have the link twice
		while($depType = $depTypeSet->next()){
			if (!isset($made[$depType->ID])){
				$made[$depType->ID]=true;
				$entity_result="";
				$return_entity_result="";
				
				$entity_result.=$depType->getXML();
				
				$moduleOriginInfo = $depType->getModuleOrigin();
				$moduleTargetInfo = $depType->getModuleTarget();
				
				if ($depType->isUTurn()){
					// it's a two-way symetric dep
					$return_entity_result = $entity_result;
					$entity_result="<DEPENDENCYTYPE from='".$moduleOriginInfo->name."' to='".$moduleTargetInfo->name."' type='start' ID='".$depType->ID."'>".$entity_result."</DEPENDENCYTYPE>";
					$return_entity_result="<DEPENDENCYTYPE from='".$moduleTargetInfo->name."' to='".$moduleOriginInfo->name."' type='start' ID='".$depType->ID."'>".$return_entity_result."</DEPENDENCYTYPE>";
				}else if ($depType->returnIsDependency()){
					// it's a two-way asymetric dep
					$entity_result="<DEPENDENCYTYPE from='".$moduleOriginInfo->name."' to='".$moduleTargetInfo->name."' type='start' ID='".$depType->ID."'>".$entity_result."</DEPENDENCYTYPE>";
					$return_dependencyType = $depType->getReturnType();
					$return_entity_result.=$return_dependencyType->getXML();
					$return_entity_result="<DEPENDENCYTYPE from='".$moduleTargetInfo->name."' to='".$moduleOriginInfo->name."' type='start' ID='".$return_dependencyType->ID."'>".$return_entity_result."</DEPENDENCYTYPE>";
					$made[$return_dependencyType->ID]=true;
				}else{
					$entity_result="<DEPENDENCYTYPE from='".$moduleOriginInfo->name."' to='".$moduleTargetInfo->name."' type='start' ID='".$depType->ID."'>".$entity_result."</DEPENDENCYTYPE>";
				}
				$query_result.="<DEPENDENCYENTITY>".$entity_result.$return_entity_result."</DEPENDENCYENTITY>";
			}
		}
		return $query_result;
	}
	
	function getShortDeps(){
		$moduleOriginInfo = $this->moduleOriginInfo;
		$depTypeSet = $this->getDeps();
		$languageID = $this->firstNode->valueOf("@languageID");
		
		$request = new Sushee_Request();
		if(!$languageID && $request->isLanguageRestricted())
			$languageID = $request->getLanguage();
		while($depType = $depTypeSet->next()){
			$moduleTargetInfo = $depType->getModuleTarget();
			$query_result.='<DEPENDENCY_TYPE from="'.$moduleOriginInfo->name.'" to="'.$moduleTargetInfo->name.'">';
			$query_result.=$depType->getTypeXML();
			$query_result.=$depType->getTraductionXML($languageID);
			$query_result.=$depType->getAnnexFieldsXML();
			$query_result.='</DEPENDENCY_TYPE>';
		}
		return $query_result;
	}
	
	function getDeps(){
		if($this->ID){
			$deps = new Vector();
			$depType = depType($this->ID);
			if($depType->loaded){ // if depType exists
				$deps->add($this->ID,$depType);
			}
			return $deps;
		}elseif($this->moduleOriginInfo && $this->moduleTargetInfo){
			// from a module to another module
			$deps = new DependencyTypeSet($this->moduleOriginInfo->getID(),$this->moduleTargetInfo->getID());
			
		}elseif($this->moduleOriginInfo){
			// from a module
			$deps = new DependencyTypeSet($this->moduleOriginInfo->getID(),false);
			
		}elseif($this->moduleTargetInfo){
			// to a module
			$deps = new DependencyTypeSet(false,$this->moduleTargetInfo->getID());
			
		}else{
			// all deptypes
			$deps = new DependencyTypeSet(false,false);
			
		}
		
		if($this->domain)
			$deps->setDomain($domain);
		return $deps->getTypes();
	}
	
	function operate(){
		$xml = '';
		$attributes = $this->getOperationAttributes();
		$xml.='<RESULTS'.$attributes.'>';
		
		if ($this->firstNode->nodeName()=='DEPENDENCYENTITY'){
			$xml.=$this->getCompleteDeps();
		}else{
			$xml.=$this->getShortDeps();
		}
		$xml.='</RESULTS>';
		$this->xml = $xml;
		return true;
	}
	
	function getXML(){
		return $this->xml;
	}
}

?>
