<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/searchField.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../private/search.inc.php');
require_once(dirname(__FILE__).'/../common/db_manip.class.php');
require_once(dirname(__FILE__)."/../common/nectil_element.class.php");

// this class calls the searchElement class but before fills the fields table if necessary

class SearchField extends RetrieveOperation{
	
	var $modules;
	
	function parse(){
		
		
		return true;
	}
	
	function operate(){
		if($this->firstNode->getAttribute('analyse-table')!=='false'){
			// 
			$list = new Vector();
			$moduleNodes = $this->firstNode->getElements('./INFO/MODULE');
			$moduleNodes[]=$this->firstNode->getElement('@module');
			// if no module indicated, handling fields of all modules
			if(sizeof($moduleNodes)==0){
				$list = new modules();
			}else{
				// handling fields of the modules indicated
				foreach($moduleNodes as $node){
					if(is_object($node)){
						$moduleInfo = moduleInfo($node->valueOf());
						if($moduleInfo->loaded){
							$list->add($moduleID,$moduleInfo);
						}
					}
				}
			}
			$db_conn = db_connect();
			while($moduleInfo = $list->next()){
				$moduleInfo->registerFields();
			}
		}
		$search = new SearchElement($this->getName(),$this->operationNode);
		$this->xml = $search->execute();
		return true;
	}
}
?>