<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/showOnlyRichText.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../common/nectil_user.class.php");
require_once(dirname(__FILE__)."/../common/mail.class.php");
require_once(dirname(__FILE__)."/../common/fields.class.php");


class MailOnlyRichTextPage extends SusheeObject{
	
	var $mail = false;
	var $ID = false;
	
	function MailOnlyRichTextPage($ID){
		$this->ID = $ID;
	}
	
	function execute(){
		$user = new NectilUser();
		if($user->isAuthentified()){
			$mail = new Mail($this->ID);
			
			$fields_collection = new FieldsCollection();
			$fields_collection->add(new DBField('OwnerID'));
			$fields_collection->add(new DBField('RichText'));
			
			$mail->loadFields($fields_collection);
			if($mail->getField('OwnerID')==$user->getID()){
				$richtext = $mail->getField('RichText');
				$richtext = str_replace(array('[files_url]','[ID]'),array($GLOBALS["files_url"],$this->ID),$richtext);
				echo $richtext;
				return;
			}else{
				$this->log('User trying to consult emails that don\'t belong to him');
			}
		}else{
			$this->log('User not authentified and trying to consult emails');
		}
	}
}

$page = new MailOnlyRichTextPage($_GET['ID']);
$page->execute();

?>