<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/transformQuery.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');

class sushee_transformQuery extends RetrieveOperation{
	
	function parse(){
		
		return true;
	}
	
	function operate(){
		//executing the commands
		$shell = new Sushee_shell();
		$shell->addCommand($this->firstNode->toString('/*'));
		
		$xslnode = $this->operationNode->getElement('XSL');
		if(!$xslnode){
			$this->setError('No XSL node found in TRANSFORM');
			return false;
		}
		// a path to a file is given
		$xslpath = $xslnode->valueOf('@path');
		if($xslpath){
			$xsl = new KernelFile($xslpath);
		}else{
			// saving the xsl template (found directly in the request) in a temporary file
			$xsl = new TempFile();
			$xsl->save($xslnode->toString('/*'));
		}
		if(!$xsl->exists()){
			$this->setError('XSL file '.$xsl->getPath().' does not exist');
			return false;
		}
		
		// transforming using the temporary file
		$result = $shell->transform($xsl->getCompletePath());
		
		$resultXML = new XML($result);
		if(!$resultXML->loaded){
			$result = encode_to_xml($result);
		}else{
			$result = $resultXML->toString('/',''); // mreoving the xml header
		}
		
		$attributes = $this->getOperationAttributes();
		$this->setXML('<RESULTS'.$attributes.'>'.$result.'</RESULTS>');
		
		return true;
	}
	
}


?>