<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/updatePropertiesConfig.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
function updatePropertiesConfig($name,&$xml,$requestName,$current_path,$firstNode,$firstNodePath){
	$db_conn = db_connect();
	$moduleInfo = moduleInfo($xml->getData($firstNodePath."/@module"));
	//$virtualID = moduleInfo($xml->getData($firstNodePath."/@virtualID"));
	if(!$moduleInfo->loaded)
		return generateMsgXML(1,'Module name is incorrect.',0,'',$name);
	$moduleID = $moduleInfo->ID;
	$previous_config_sql = 'SELECT ID FROM `propertiesconfig` WHERE `ModuleID`=\''.$moduleID.'\'';
	$previous_config_rs = $db_conn->Execute($previous_config_sql);
	while($config = $previous_config_rs->FetchRow()){
		$del_sql = 'DELETE FROM `propertiestraductions` WHERE PropertyID='.$config['ID'].';';
		$db_conn->Execute($del_sql);
	}
	$delete_previous_config = 'DELETE FROM `propertiesconfig` WHERE `ModuleID`=\''.$moduleID.'\'';
	$db_conn->Execute($delete_previous_config);
	
	// to have the config of the table
	$sql = "SELECT * FROM `propertiesconfig` WHERE ID=-1;";
	$pseudo_propertiesconfig_rs = $db_conn->Execute($sql);
	$sql = "SELECT * FROM `propertiestraductions` WHERE PropertyID=-1;";
	$pseudo_propertiestraductions_rs = $db_conn->Execute($sql);
	
	$property_array = $xml->match($firstNodePath.'/PROPERTY');
	foreach($property_array as $property_path){
		$property_name = $xml->getData($property_path."/NAME[1]");
		$property_type = $xml->getData($property_path."/TYPE[1]");
		$property_default_value = $xml->getData($property_path."/DEFAULTVALUE[1]");
		$property_virtualID = $xml->getData($property_path."/VIRTUALID[1]");
		$property_row = array("Denomination"=>decode_from_XML($property_name),"Type"=>$property_type,'DefaultValue'=>decode_from_XML($property_default_value),"ModuleID"=>$moduleID,"VirtualID"=>$property_virtualID);
		$sql = $db_conn->GetInsertSQL($pseudo_propertiesconfig_rs, $property_row);
		$db_conn->Execute($sql);
		$propertyID = $db_conn->Insert_Id();
		
		$labels_array = $xml->match($property_path."/LABEL[@languageID!='']");
		foreach($labels_array as $label_path){
			$languageID=$xml->getData($label_path.'/@languageID');
			$label_title = $xml->getData($label_path."/TITLE[1]");
			$label_unit = $xml->getData($label_path."/UNIT[1]");
			$label_comment = $xml->getData($label_path."/COMMENT[1]");
			$label_row = array("PropertyID"=>$propertyID,"LanguageID"=>$languageID,"Title"=>decode_from_XML($label_title),"Unit"=>decode_from_XML($label_unit),"Comment"=>decode_from_XML($label_comment));
			$sql = $db_conn->GetInsertSQL($pseudo_propertiestraductions_rs, $label_row);
			$db_conn->Execute($sql);
		}
	}
	$query_result = generateMsgXML(0,'Properties configuration successfully modified.',0,'',$name);
	return $query_result;

}
?>
