<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/templates/workflow.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	<xsl:param name="element" select="/RESPONSE/RESULTS[@name='element']/*[1]"/>
	<xsl:param name="editor" select="/RESPONSE/RESULTS[@name='editor']/CONTACT"/>
	<xsl:param name="submitted_desc" select="($element/DESCRIPTIONS/DESCRIPTION[STATUS='submitted' or STATUS='checked'])[1]"/>
	<xsl:template match="/RESPONSE">
		<html>
			<body>
				<h1 style="font-size:15px;">
					<xsl:value-of select="$submitted_desc/TITLE"/>
				</h1>
				<h2 style="font-size:14px;font-weight:normal;font-style:italic;">
					<xsl:text>submitted by : </xsl:text>
					<xsl:value-of select="$editor/INFO/FIRSTNAME"/>
					<xsl:text> </xsl:text>
					<xsl:value-of select="$editor/INFO/LASTNAME"/>
					<xsl:text> on </xsl:text>
					<xsl:value-of select="substring($submitted_desc/MODIFICATIONDATE,9,2)"/>
					<xsl:text>/</xsl:text>
					<xsl:value-of select="substring($submitted_desc/MODIFICATIONDATE,6,2)"/>
					<xsl:text>/</xsl:text>
					<xsl:value-of select="substring($submitted_desc/MODIFICATIONDATE,1,4)"/>
					<xsl:text> at </xsl:text>
					<xsl:value-of select="substring($submitted_desc/MODIFICATIONDATE,12,5)"/>
				</h2>
				
				<p>
					<xsl:text>Preview it here : </xsl:text>
					<xsl:value-of select="/RESPONSE/NECTIL/public_url"/><xsl:value-of select="$element/INFO/MEDIATYPE"/>.php?ID=<xsl:value-of select="$element/@ID"/>&amp;version=<xsl:value-of select="$submitted_desc/@ID"/>
				</p>
				
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>