/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class SingleNodeIterator
implements AxisIterator,
UnfailingIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private NodeInfo item;
    private int position = 0;

    private SingleNodeIterator(NodeInfo nodeInfo) {
        this.item = nodeInfo;
    }

    public static AxisIterator makeIterator(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return EmptyIterator.getInstance();
        }
        return new SingleNodeIterator(nodeInfo);
    }

    public boolean hasNext() {
        return this.position == 0;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public Item next() {
        if (this.position == 0) {
            this.position = 1;
            return this.item;
        }
        if (this.position == 1) {
            this.position = -1;
            return null;
        }
        return null;
    }

    public Item current() {
        if (this.position == 1) {
            return this.item;
        }
        return null;
    }

    public int position() {
        return this.position;
    }

    public int getLastPosition() {
        return 1;
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        if (this.position == 1) {
            return this.item.iterateAxis(by, nodeTest);
        }
        throw new NullPointerException();
    }

    public Value atomize() throws XPathException {
        if (this.position == 1) {
            return this.item.atomize();
        }
        throw new NullPointerException();
    }

    public CharSequence getStringValue() {
        if (this.position == 1) {
            return this.item.getStringValueCS();
        }
        throw new NullPointerException();
    }

    public SequenceIterator getAnother() {
        return new SingleNodeIterator(this.item);
    }

    public SequenceIterator getReverseIterator() {
        return new SingleNodeIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    public Value materialize() {
        return new SingletonNode(this.item);
    }

    public int getProperties() {
        return 7;
    }
}

