<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/contacts/New.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="title" select= "'New contact'" />
    		<xsl:with-param name="tabsList" select= "'info,Basic details;'" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : info form -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />  
             	
       	<xsl:apply-templates select="$element/INFO/LASTNAME" mode="form-info-line">
       	</xsl:apply-templates>       	
       	<xsl:apply-templates select="$element/INFO/FIRSTNAME" mode="form-info-line">
       	</xsl:apply-templates>       	
       	<xsl:apply-templates select="$element/INFO/TITLE" mode="form-info-line" />
       	
       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="form-info-line">
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/EMAIL1" mode="form-info-line">
       		<xsl:with-param name="required" select="true()"  />
       	</xsl:apply-templates>
       	       	
    	<xsl:apply-templates select="$element/INFO/ADDRESS" mode="form-info-line">
        	<xsl:with-param name="type" select="'textarea'" /> 
        </xsl:apply-templates>
        <xsl:apply-templates select="$element/INFO/POSTALCODE" mode="form-info-line">
        </xsl:apply-templates>
        <xsl:apply-templates select="$element/INFO/CITY" mode="form-info-line">
        </xsl:apply-templates>
        <xsl:apply-templates select="$element/INFO/COUNTRYID" mode="form-info-line">
        </xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/DIGITALINFO1" mode="form-info-line">
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/MOBILEPHONE" mode="form-info-line" /> 
       	
       	<xsl:apply-templates select="$element/INFO/PHONE1" mode="form-info-line" />
       	         
       	<xsl:apply-templates select="$element/INFO/LANGUAGEID" mode="form-info-line">
       		<xsl:with-param name="inputValue" select="'eng'" />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/BIRTHDAY" mode="form-info-line">
       		<xsl:with-param name="inputValue" select="$now" />
       	</xsl:apply-templates>           	           	

       	<xsl:apply-templates select="$element/INFO/PRIVACY1" mode="form-info-line">
       		<xsl:with-param name="inputValue" select="1" />
       	</xsl:apply-templates>   
       	       
       	<xsl:apply-templates select="$element/INFO/PREVIEW" mode="form-info-line" />   
       	
       	<!--xsl:variable name="societyInputName">
			<xsl:call-template name="gen-dep-input-name">
				<xsl:with-param name="dependencyType" select="'contactWork'" />
				<xsl:with-param name="moduleName" select="'contact'" />
				<xsl:with-param name="serviceName" select="'info'" />
				<xsl:with-param name="fieldName" select="'ID'" />
				<xsl:with-param name="type" select="'list'" />
			</xsl:call-template>
       	</xsl:variable>       	
     	<xsl:call-template name="form-info-line">
       		<xsl:with-param name="label" select="'Society:'" />
	    	<xsl:with-param name="input">
                <select name="{$societyInputName}" class="input-select">
                    <option value="">
                        <xsl:text>(Choose a society)</xsl:text>
                    </option>
                    <xsl:for-each select="/RESPONSE/RESULTS[@name='societies']/*">
                        <xsl:sort select="INFO/DENOMINATION" />
                        <option value="{@ID}">
                            <xsl:value-of select="INFO/DENOMINATION"/>
                        </option>
                    </xsl:for-each>
                </select>
	    	</xsl:with-param> 
    	</xsl:call-template-->
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit">
       		<xsl:with-param name="buttonLabel" select="'Create'"/>
       	</xsl:apply-templates>
    </xsl:template>
</xsl:stylesheet>