<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/ModuleDetails.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');

    /* *** */
    function getPublishedEnvironments()
	{
		$nql = new Sushee_Shell(false);
		$nql->addCommand('
			<SEARCH>
				<OFFICITY:ENVIRONMENT>
					<INFO>
						<PUBLISHED operator="=">1</PUBLISHED>
						<TYPE operator="NE">versions</TYPE>
					</INFO>
				</OFFICITY:ENVIRONMENT>
				<RETURN>
					<INFO>
						<FOLDER />
						<TYPE />
					</INFO>
				</RETURN>
			</SEARCH>
		');
		$nql->execute();
		
		return $nql->getElements('/RESPONSE/RESULTS/OFFICITY:ENVIRONMENT');
	}
		
    /* *** */
    
    $nql = new Officity_Shell();

    $search_attribute = URLParam::exists('ID') ? 'ID="'.URLParam::fetch('ID').'"' : 'denomination="'.URLParam::fetch('denomination').'"';
	$nql->addCommand('
		<GET>
			<MODULE '.$search_attribute.' />
			<RETURN depth="2">
				<INFO>
					<DENOMINATION />
				</INFO>
				<DEPENDENCIES>
					<DEPENDENCY type="officity:moduleNamespaces">
						<INFO>
							<NAMESPACE />
						</INFO>
					</DEPENDENCY>
				</DEPENDENCIES>
			</RETURN>
		</GET>
	');
	$nql->execute();
	$denomination = $nql->valueOf('/RESPONSE/RESULTS/MODULE/INFO/DENOMINATION');
	
	if (empty($denomination))
	{
		throw new OfficityException('Module not found! ('.$search_attribute.')');
	}
	
	$namespace = $nql->valueOf('/RESPONSE/RESULTS/MODULE/DEPENDENCIES/DEPENDENCY[@type="officity:moduleNamespaces"]/NAMESPACE/INFO/NAMESPACE');
    
    $nql_command = '
        <GET name="item">
            <MODULE '.$search_attribute.' />
            <RETURN depth="2">
                <INFO creator_info="small" modifier_info="small" owner_info="small"/>
                <DEPENDENCIES>
                	<DEPENDENCY type="officity:moduleNamespaces">
                		<INFO>
                			<NAMESPACE />
                			<EDITOR />
	                	</INFO>
                	</DEPENDENCY>
                </DEPENDENCIES>
                <DESCRIPTIONS>
                	<DESCRIPTION languageID="all" />
                </DESCRIPTIONS>
            </RETURN>
        </GET>
    ';
    $nql->addCommand($nql_command);	
    $nql->addModuleFields('MODULE');
    $nql->addMonths();
    $nql->addCommand('
    	<GET>
	    	<LIST name="ModuleTypes" />
    	</GET>
    ');
    $nql->addCommand('
    	<GET>
	    	<LIST name="EnvironmentType" />
    	</GET>
    ');
    
    // element template (for 'new' navigation item)
    $nql->addCommand('
        <GET name="templateItem" refresh="monthly">
            <'.strtoupper($denomination).' ID="1"/>
            <RETURN>
                <INFO />
            </RETURN>
        </GET>
    ');
    
    // get shared files
    // check namespace
    $module_folder_name = strtolower($denomination);
	$denom_slices = explode(':', $module_folder_name);
	if ($denom_slices[0] != $module_folder_name)
	{
		$module_folder_name = $denom_slices[1];
	}	
    
	$files_xml = '<MODULEFILES>';
	$env_elements = getPublishedEnvironments();
	foreach ($env_elements as $env)
	{
		$files_xml .= '<ENVIRONMENT type="'.$env->valueOf('INFO/TYPE').'">';
		
		$module_folder_path = '/'.$env->valueOf('INFO/FOLDER').'/'.$namespace.'/shared/'.$module_folder_name;
		$module_folder = new KernelFolder($module_folder_path);
		if ($module_folder->exists())
		{
			while ($file = $module_folder->getNextFile())
			{
				$name = $file->getName();
				if ($name[0] == '.') continue;
				$files_xml .= '<FILENAME>'.$name.'</FILENAME>';
			}
		}
		
		$files_xml .= '</ENVIRONMENT>';
	}
	$files_xml .= '</MODULEFILES>';
	
	$nql->addStatic($files_xml, 'modulefiles');

    echo $nql->transform(dirname(__FILE__).'/ModuleDetails.xsl');
?>