<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/ProcessorNew.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="title" select= "'New Processor'" />
    		<xsl:with-param name="titlecssclass" select= "'processor'" />
    		<xsl:with-param name="tabsList" select= "'info,Details;'" />
    		<!--xsl:with-param name="displayNavDetails" select="true()" /-->
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : info form -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />  
		
		<xsl:choose>
			<xsl:when test="not(/RESPONSE/URL/targetModuleID)">
				<xsl:variable name="targetModuleInputName">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="'processor'" />
						<xsl:with-param name="fieldName" select="'moduleid'" />
					</xsl:call-template>
				</xsl:variable>
		
		       	<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Module:'"  />
					<xsl:with-param name="input">
				        <select class="input-select required" name="{$targetModuleInputName}">
				            <option value="">
				                <xsl:text>(Choose a module)</xsl:text>
				            </option>
				            <xsl:for-each select="/RESPONSE/RESULTS[@name='modules']/MODULE">
				                <xsl:sort select="INFO/DENOMINATION" />
				                <option value="{INFO/DENOMINATION}">
				                    <xsl:value-of select="INFO/DENOMINATION"/>
				                </option>
				            </xsl:for-each>
				        </select>
					</xsl:with-param>
					<xsl:with-param name="required" select="true()" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="$element/INFO/MODULEID" mode="form-info-line">
					<xsl:with-param name="hidden" select="true()" />
					<xsl:with-param name="inputValue" select="/RESPONSE/URL/targetModuleID" />
				</xsl:apply-templates>
		
				<xsl:call-template name="overview-line">
					<xsl:with-param name="label" select="'Module:'" />
					<xsl:with-param name="value" select="/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		
       	<xsl:apply-templates select="$element/INFO/TYPE" mode="form-info-line">
       		<xsl:with-param name="required" select="true()" />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/COMMAND" mode="form-info-line">
       		<xsl:with-param name="required" select="true()" />
       	</xsl:apply-templates>          
       	
       	<xsl:variable name="m">
       		<xsl:choose>
       			<xsl:when test="substring-after(/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION, ':')">
       				<xsl:value-of select="substring-after(/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION, ':')" />
       			</xsl:when>
       			<xsl:otherwise>
       				<xsl:value-of select="/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION" />
       			</xsl:otherwise>
       		</xsl:choose>
       	</xsl:variable>
       	<xsl:variable name="ns">
       		<xsl:choose>
       			<xsl:when test="substring-before(/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION, ':')">
       				<xsl:value-of select="substring-before(/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION, ':')" />
       			</xsl:when>
       			<xsl:otherwise>
       				<xsl:text>sushee</xsl:text>
       			</xsl:otherwise>
       		</xsl:choose>
       	</xsl:variable>
       	
       	<xsl:apply-templates select="$element/INFO/PATH" mode="form-info-line">
       		<xsl:with-param name="required" select="true()" />
       		<xsl:with-param name="inputValue">
       			<xsl:if test="/RESPONSE/RESULTS[@name='targetEnv']/OFFICITY:ENVIRONMENT">
       				<xsl:text>/</xsl:text>
       				<xsl:value-of select="/RESPONSE/RESULTS[@name='targetEnv']/OFFICITY:ENVIRONMENT/INFO/FOLDER" />
       				<xsl:text>/</xsl:text>
       				<xsl:value-of select="$ns" />
       				<xsl:text>/shared/</xsl:text>
       				<xsl:value-of select="$m" />
       				<xsl:text>/</xsl:text>
       				<xsl:value-of select="$m" />
       				<xsl:text>-processors.class.php</xsl:text>
       			</xsl:if>
       		</xsl:with-param>
       	</xsl:apply-templates> 
       	
       	<xsl:apply-templates select="$element/INFO/CLASSNAME" mode="form-info-line">
       		<xsl:with-param name="required" select="true()" />
       		<xsl:with-param name="inputValue">
				<xsl:call-template name="capitalise">
					<xsl:with-param name="text" select="$ns" />
					<xsl:with-param name="all" select="false()"/>
				</xsl:call-template>
       			<xsl:text>_</xsl:text>
				<xsl:call-template name="capitalise">
					<xsl:with-param name="text" select="$m" />
					<xsl:with-param name="all" select="false()"/>
				</xsl:call-template>
				<xsl:text>Processor</xsl:text>
       		</xsl:with-param>
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/METHOD" mode="form-info-line">
       		<xsl:with-param name="required" select="true()" />
       	</xsl:apply-templates>
       	     
       	<xsl:apply-templates select="$element/INFO/ORDERING" mode="form-info-line">
       	
       		<xsl:with-param name="extraLabel" select="'Leave empty if not relevant.'" />
       	</xsl:apply-templates>     
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit">
       		<xsl:with-param name="buttonLabel" select="'Create'"/>
      		<xsl:with-param name="createAndNew" select="true()" />
       	</xsl:apply-templates>
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <!--xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Publishers'"/>
			<xsl:with-param name="panelURI" select="'factory/modules/Help'"/>
            <xsl:with-param name="cssclass">first last</xsl:with-param>
			<xsl:with-param name="params">
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/help-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>		
    </xsl:template-->
</xsl:stylesheet>