<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/publish/Index.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-navigation" />
	</xsl:template>
	
	<!-- navigation body -->
	<xsl:template name="panel-body-navigation">
        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">Publisher</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/publish/publish-32.png</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:text>Publisher allows to move editors applications code base and resources from one environment to another.</xsl:text><br />
            	<xsl:text>Before publishing, the target environment will be archived in the "Versions" folder. A release element will be created, including the path of the archive and an optional comment.</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        
        <xsl:choose>
            <xsl:when test="count($list/OFFICITY:ENVIRONMENT[INFO/TYPE!='production']) > 0">
	            <xsl:apply-templates select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='development']" mode="publish-actions">
	            	<xsl:with-param name="targetEnv" select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='beta']" />
	            </xsl:apply-templates>
	            <xsl:apply-templates select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='development']" mode="publish-actions">
	            	<xsl:with-param name="targetEnv" select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='production']" />
	            </xsl:apply-templates>
	            <xsl:apply-templates select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='beta']" mode="publish-actions">
	            	<xsl:with-param name="targetEnv" select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='production']" />
	            </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
                	<xsl:text>Development and Beta environments are currently not activated.</xsl:text>
                	<br /><br />
               		<span style="font-size:0.7em;">
               			<xsl:text>To activate them, go to </xsl:text>
               			<a href="#" title="Manage environments">
               				<xsl:attribute name="onclick">
				                <xsl:call-template name="navhandler">
				                    <xsl:with-param name="title" select="'Environments'"/>
				                    <xsl:with-param name="panelURI" select="'environments/Index'" />                    
				                </xsl:call-template>
               				</xsl:attribute>
               				<xsl:text>Factory > Environments</xsl:text>
               			</a>
            		</span>
                </div>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="navigationitem">
            <xsl:with-param name="title">All releases</xsl:with-param>
            <xsl:with-param name="panelURI">publish/ReleasesList</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/publish/release-16.png</xsl:with-param>
            <xsl:with-param name="params">
            </xsl:with-param>
        </xsl:call-template>
		<xsl:call-template name="navigationitem">
			<xsl:with-param name="title" select="'All release notes'"/>
			<xsl:with-param name="panelURI" select="'releasenotes/ReleaseNotesList'"/>
			<xsl:with-param name="params">
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/publish/releasenote-16.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="OFFICITY:ENVIRONMENT" mode="publish-actions">
		<xsl:param name="targetEnv" />
		<xsl:if test="$targetEnv">
			<xsl:call-template name="navigationitem">
		        <xsl:with-param name="icon">
		        	<xsl:apply-templates select="." mode="element-icon" />
		        </xsl:with-param>
				<xsl:with-param name="title">
					<xsl:apply-templates select="." mode="element-label" />
					<xsl:text> => </xsl:text>
					<img style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 9px 0 4px;">
						<xsl:attribute name="src">
							<xsl:value-of select="$systemURL" />
							<xsl:text>../</xsl:text>
							<xsl:value-of select="/RESPONSE/URL/editor" />
							<xsl:text>/</xsl:text>
							<xsl:apply-templates select="." mode="element-icon" />
						</xsl:attribute>
					</img>
					<xsl:apply-templates select="$targetEnv" mode="element-label" />
				</xsl:with-param>
				<xsl:with-param name="panelURI" select="'publish/Publish'"/>
				<xsl:with-param name="params">
					<xsl:text>originEnv:'</xsl:text>
					<xsl:value-of select="INFO/TYPE"/>
					<xsl:text>', targetEnv:'</xsl:text>
					<xsl:value-of select="$targetEnv/INFO/TYPE"/>
					<xsl:text>'</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>