<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/Index.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');
    
    /* *** */
    
    function favoritesExist()
    {
		$nql = new Sushee_Shell(false);
		$nql->addCommand('
			<SEARCH>
				<OFFICITY:LIBITEM>
					<DEPENDENCIES>
						<DEPENDENCY type="officity:contactFavorites" mode="reverse">
							<CONTACT ID="visitor" />
						</DEPENDENCY>
					</DEPENDENCIES>
				</OFFICITY:LIBITEM>
				<RETURN>
					<NOTHING />
				</RETURN>
			</SEARCH>
	    ');
    	$nql->execute();
    
    	return ($nql->valueOf('/RESPONSE/RESULTS/@hits') > 0);
    }

    function addVirtualServer(&$nql)
    {
        $server_nql = new Sushee_Shell(false);
	    $server_nql->addCommand('
	    	<SEARCH name="servers">
	    		<OFFICITY:LIBITEM>
	    			<INFO>
	    				<TYPE operator="=">server</TYPE>
	    			</INFO>
	    		</OFFICITY:LIBITEM>
	    		<RETURN>
	    			<NOTHING />
	    		</RETURN>
	    	</SEARCH>
	    ');
	    $server_nql->execute();
	    $servers = $server_nql->getElements('/RESPONSE/RESULTS[@name="servers"]/OFFICITY:LIBITEM');
	       
	    if (count($servers) == 0)
	    {
	    	throw new OfficityAppException('Virtual server not found!');
	    }
	    else if (count($servers) > 1)
	    {
	    	throw new OfficityAppException('Multiple virtual servers found!');
	    }
	    
	    $nql->addStatic($servers[0]->toString(), 'server');
	    
	    return $servers[0];
    }
    
    /* *** */
    
    $nql = new Officity_Shell();
    $nql->addList('DocumentsTypes'); // header quick add forms
    
    // search?
    if (URLParam::isNotEmpty('quicksearch-text') || URLParam::isNotEmpty('quicksearch-favs'))
    {
    	$search_text = '';
    	
    	// quick search?
    	if (URLParam::isNotEmpty('quicksearch-text')) 
    	{
        	// set display mode
    		$nql->addParam2XML('mode', 'searchitems');
    		$search_text = URLParam::fetch('quicksearch-text');
    	}
    	else // favorites seacrh?
    	{
        	// set display mode
    		$nql->addParam2XML('mode', 'searchfavs');
    		$search_text = URLParam::fetch('quicksearch-favs');
    		
		    $dep_module = new Officity_LibitemElement();
		    $dep_module->setDependencyByName('officity:contactFavorites', 'CONTACT', 'visitor', 'reverse', '');
		    $dep_module->setNoReturn();
		    $dep_module->search('depsList', false);
		    $search_command = $dep_module->getNQLCommand();
		    $nql->addCommand($search_command);
    	}
 	
    	$items = new Officity_LibitemElement();
    	
    	$items->addSearchInfo('TYPE', 'NE', 'server');
    	$items->addSearchInfo('SEARCHTEXT', 'MATCH', $search_text);
	    	    
	    $items->setDisplayProfile();
	    $items->setDefaultPaginate(URLParam::fetch('display', 50), URLParam::fetch('page', 1));
		$items->search('list', false);
		$search_command = $items->getNQLCommand();
	    $nql->addCommand($search_command);
	    
	    $nql->addPaging();	    	    
	    addVirtualServer($nql);
    }
    else // no search
    {
    	if (favoritesExist() == true) // display visitor's favorites
    	{
    		// set display mode
    		$nql->addParam2XML('mode', 'displayfavs');
    		
    		// get server ID, needed for the "All disks" navitem 
    		$server = addVirtualServer($nql);
    		$SERVER_ID = $server->valueOf('@ID');
    		$nql->addParam2XML('serverID', $SERVER_ID);
    		
		    $nql->addCommand('
		    	<GETCHILDREN name="list" type="officity:contactFavorites">
		            <CONTACT ID="visitor" />
		            <RETURN>
		                <INFO>
				            <TITLE />
				            <SUMMARY />
				            <TYPE />
				            <KIND />
				            <SIZEHUMAN />
				            <ITEMS />
				    		<TRASHED />
		                </INFO>
						<DESCRIPTIONS>
							<DESCRIPTION>
								<TITLE />
								<SUMMARY />
							</DESCRIPTION>
						</DESCRIPTIONS>
		            </RETURN>
		    	</GETCHILDREN>
		    '); 
		    $nql->addCommand('
		    	<GET name="container">
		    		<CONTACT ID="visitor" />
		    		<RETURN>
		    			<NOTHING />
		    		</RETURN>
		    	</GET>
		    ');
    	}
    	else // no favorites : display all disks
    	{
    		// set display mode
    		$nql->addParam2XML('mode', 'displaydisks');
    		
    		// needed for sorting
    		$server = addVirtualServer($nql);
    		$SERVER_ID = $server->valueOf('@ID');
    		$nql->addParam2XML('serverID', $SERVER_ID);
    		
		    $nql->addCommand('
		    	<GETCHILDREN name="list" type="officity:content">
		            <OFFICITY:LIBITEM ID="'.$SERVER_ID.'" />
		            <RETURN>
		                <INFO>
							<TITLE />
							<TYPE />
							<TRASHED />
		                </INFO>
		            </RETURN>
		    	</GETCHILDREN>
		    ');
		    $nql->addStatic('
		    	<OFFICITY:LIBITEM ID="'.$SERVER_ID.'" />
		    ', 
		    'container');
    	}
    }
    
    // trash count
    $nql->addCommand('
    	<COUNT name="trashedItemsCount">
    		<OFFICITY:LIBITEM>
    			<INFO>
    				<TRASHED operator="NE">no</TRASHED>
    			</INFO>
    		</OFFICITY:LIBITEM>
    	</COUNT>
    ');
    
	die ($nql->transform(dirname(__FILE__).'/Index.xsl'));
?>