<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/Trash.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />
    
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-results">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="pagingStyle" select="'pager'"/>
	        <xsl:with-param name="addNew" select="false()" />  
	        <xsl:with-param name="params">
	        </xsl:with-param>
    	</xsl:call-template>
    </xsl:template>

	<!-- custom : title -->
	<xsl:template name="panel-title">
		<xsl:call-template name="truncate-phrase">
			<xsl:with-param name="phrase" select="/RESPONSE/URL/title"/>
		</xsl:call-template>
			
	</xsl:template>
	
	<!-- results list header -->
	<xsl:template name="panel-list-header-results">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        
		<xsl:call-template name="staticitem">
			<xsl:with-param name="info">
				<input type="button" value="Empty trash" title="Delete all trashed items">
					<xsl:attribute name="style">
						cursor:pointer;
						-moz-border-radius:7px;
						-webkit-border-radius:7px;
						border:2px solid #969899;
						color:white;
						font-weight:bold;
						padding:0px 4px 5px 4px;
						background:#969899;
						cursor:pointer;
						height:20px;
						margin-top:5px;
					</xsl:attribute>
					<xsl:attribute name="onclick">
			            var emptyRequest = new AjaxRequest(
			                <xsl:value-of select="/RESPONSE/URL/panelID" />,
			                AppController,
			                '<xsl:value-of select="$systemURL" /><xsl:text disable-output-escaping="yes">call-operation.php?editor=officity&amp;module=libitem&amp;opObject=Officity_LibitemElementOperation&amp;op=emptyTrash</xsl:text>',
			                'POST'
			            );
			            
			            // error dialogs
			            emptyRequest.errorDialog(true, false);
			            emptyRequest.internalErrorDialog(true, false); 
			            
			            emptyRequest.onSuccess(function(){
			            	$('#<xsl:value-of select="$panelID" />.panel').trigger('panel-displayloader', [false, 'body']);
		            		$('#<xsl:value-of select="$panelID" />.panel').trigger('panel-reload');	
		            		$('#slider').find('.panel-lib-index').trigger('panel-refresh');
			            }).onError(function(){
			            	$('#<xsl:value-of select="$panelID" />.panel').trigger('panel-displayloader', [false, 'body']);
			            });
			            
			            $('#<xsl:value-of select="$panelID" />.panel').trigger('panel-displayloader', [true, 'body']);     
			            
			            emptyRequest.send();
			            
						return false;
					</xsl:attribute>
				</input>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="panel-list-results">  
		<xsl:param name="list" />
				
		<xsl:choose>  
			<xsl:when test="$list/*">
				<xsl:for-each select="$list/*">
					<xsl:sort select="INFO/TYPE='file'" />
					<xsl:sort select="INFO/TYPE='folder'" />
					<xsl:sort select="INFO/TYPE='disk'" />
					<xsl:sort select="INFO/TITLE" />
					<xsl:apply-templates select="." mode="element-navitem" />
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<div class="no-result">No hits</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
</xsl:stylesheet>