<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/followup/followup.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:OFFICITY="http://officity.com" version="1.0">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="OFFICITY:FOLLOWUP" mode="element-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
		
    <!-- LABEL(s) -->
	<xsl:template match="OFFICITY:FOLLOWUP" mode="element-label">
        <xsl:apply-templates select="INFO/CREATOR/*" mode="element-label"/>
		<xsl:text> - </xsl:text>
		<xsl:apply-templates select="INFO/CREATIONDATE" mode="datetime"/>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<!--xsl:template match="OFFICITY:FOLLOWUP" mode="element-info">
	</xsl:template-->
	
	<!-- ICON(s) -->
	<xsl:template match="OFFICITY:FOLLOWUP" mode="element-icon">
		<xsl:text>../system/images/icons/followups/bubble.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:FOLLOWUP[INFO/TYPE='internal']" mode="element-icon">
		<xsl:text>../system/images/icons/followups/internal.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:FOLLOWUP[INFO/TYPE='phone']" mode="element-icon">
		<xsl:text>../system/images/icons/followups/phone.png</xsl:text>
	</xsl:template>
	
	<xsl:template match="OFFICITY:FOLLOWUP[INFO/TYPE='email']" mode="element-icon">
		<xsl:text>../system/images/icons/followups/mailto.png</xsl:text>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="OFFICITY:FOLLOWUP" mode="element-id">
   		<xsl:call-template name="translate-namespace-name">
       		<xsl:with-param name="name" select="name(.)"/>
       	</xsl:call-template>
	    <xsl:text>-</xsl:text>
	    <xsl:value-of select="@ID"/>
    </xsl:template>
	
	<!-- SCRIPTS -->
	<xsl:template match="OFFICITY:FOLLOWUP" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=</xsl:text>
		<xsl:apply-templates select="." mode="element-editor" />
		<xsl:text disable-output-escaping="yes">&amp;module=followup</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Officity_FollowupElementOperation</xsl:text>
	</xsl:template>
	
	<!--xsl:template match="OFFICITY:FOLLOWUP" mode="element-script-dummyop">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=dummyOperation</xsl:text>
	</xsl:template-->
	
	<!-- NEW FOLLOWUP -->
	<xsl:template name="new-followup">
		<xsl:param name="element"/>
		<xsl:param name="title">
			<xsl:choose>
				<xsl:when test="/RESPONSE/RESULTS[@name='followups-count']">
					<xsl:value-of select="/RESPONSE/RESULTS[@name='followups-count']/@hits" />
					<xsl:text> </xsl:text>
					<xsl:text>note(s)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>Notes</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:param name="cssclass"/>
		<xsl:param name="params"/>

		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="$title"/>
			<xsl:with-param name="panelURI" select="'../../officity/shared/followup/List'"/>
			<xsl:with-param name="cssclass" select="$cssclass"/>
			<xsl:with-param name="params">
				<xsl:text>elementID:</xsl:text>
				<xsl:value-of select="$element/@ID"/>
				<xsl:text>,module:'</xsl:text>
				<xsl:value-of select="name($element)"/>
				<xsl:text>',</xsl:text>
				<xsl:value-of select="$params" />
			</xsl:with-param>
			<xsl:with-param name="icon">
				<!--xsl:text>../system/images/icons/followups/bubble.png</xsl:text-->
			</xsl:with-param> 
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>