<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/dependency/dependency.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="DEPENDENCYTYPE" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="DEPENDENCYTYPE" mode="element-application">
		<xsl:text>factory</xsl:text>
	</xsl:template>
	<xsl:template match="DEPENDENCYTYPE" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
    <!-- LABEL(s) -->
	<xsl:template match="DEPENDENCYTYPE" mode="element-label">
		<xsl:value-of select="TYPE" />
		<xsl:text> </xsl:text>
		<xsl:choose>
			<xsl:when test="@from=@to">
				<img src="{$systemImagesURL}/icons/dependencies/arrows-sym.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="{$systemImagesURL}/icons/dependencies/arrow-right.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="@to" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="DEPENDENCYTYPE" mode="element-icon">
		<xsl:text>../system/images/icons/dependencies/link-16.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="DEPENDENCYTYPE" mode="element-info">
		<xsl:variable name="returnDep" select="parent::DEPENDENCYENTITY/DEPENDENCYTYPE[TYPE!=current()/TYPE]" />
		<xsl:if test="$returnDep">
			<xsl:value-of select="$returnDep/@to" /> 
			<xsl:text> </xsl:text>
			<img src="{$systemImagesURL}/icons/dependencies/arrow-left.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="$returnDep/TYPE" />
		</xsl:if>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="DEPENDENCYTYPE" mode="element-navitem-parms">
		<xsl:variable name="returnDep" select="parent::DEPENDENCYENTITY/DEPENDENCYTYPE[TYPE!=current()/TYPE]" />
		
        <xsl:text>startID:</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>, fromDenom:'</xsl:text>
        <xsl:value-of select="@from"/>
        <xsl:text>', toDenom:'</xsl:text>
        <xsl:value-of select="@to"/>
        <xsl:text>'</xsl:text>
        <xsl:if test="$returnDep">
        	<xsl:text>, returnID:</xsl:text>
        	<xsl:value-of select="$returnDep/@ID"/>
        </xsl:if>
    </xsl:template>
	
	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="DEPENDENCYTYPE" mode="element-script-detail">
		<xsl:text>modules/DependencyDetails</xsl:text>
	</xsl:template>
</xsl:stylesheet>