<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee/shared/module/module.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<!-- EDITOR/APPLICATION -->
	<xsl:template match="MODULE" mode="element-editor">
		<xsl:text>sushee</xsl:text>
	</xsl:template>
	<xsl:template match="MODULE" mode="element-application">
		<xsl:text>factory</xsl:text>
	</xsl:template>
	<xsl:template match="MODULE" mode="element-application-editor">
		<xsl:text>officity</xsl:text>
	</xsl:template>
	
    <!-- LABEL(s) -->
	<xsl:template match="MODULE" mode="element-label">
        <xsl:if test="DESCRIPTIONS/DESCRIPTION/HEADER">
        	<xsl:value-of select="DESCRIPTIONS/DESCRIPTION/HEADER" />
        	<xsl:text> - </xsl:text>
        </xsl:if>
        <xsl:apply-templates select="INFO/DENOMINATION" mode="display-value"/>
        <xsl:if test="INFO/EXTENDS/text()">
	        <xsl:text> (extends </xsl:text>
	        <xsl:value-of select="INFO/EXTENDS"/>
	        <xsl:text>)</xsl:text>
        </xsl:if>
	</xsl:template>
	
	<!-- ICON(s) -->
	<xsl:template match="MODULE" mode="element-icon">
		<xsl:text>../system/images/icons/modules/module-16.png</xsl:text>
	</xsl:template>
	
	<!-- INFO LABEL(s) -->
	<xsl:template match="MODULE" mode="element-info">
        <xsl:apply-templates select="DEPENDENCIES/DEPENDENCY[@type='officity:moduleNamespaces']/NAMESPACE" mode="element-label"/>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="MODULE" mode="element-navitem-parms">
        <xsl:text>ID:</xsl:text>
        <xsl:value-of select="@ID"/>
        <xsl:text>,module:'</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text>',denomination:'</xsl:text>
        <xsl:value-of select="INFO/DENOMINATION"/>
        <xsl:text>'</xsl:text>
    </xsl:template>
	
	<!-- TITLE(s) -->
	
	<!-- SCRIPTS -->
	<xsl:template match="MODULE" mode="element-script-detail">
		<xsl:text>modules/ModuleDetails</xsl:text>
	</xsl:template>

	<xsl:template match="MODULE" mode="element-script-new">
		<xsl:text>modules/ModuleNew</xsl:text>
	</xsl:template>	

	<xsl:template match="MODULE" mode="element-script-ops">
		<xsl:value-of select="$systemURL" />
		<xsl:text>call-operation.php?editor=sushee</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;module=module</xsl:text>
		<xsl:text disable-output-escaping="yes">&amp;opObject=Sushee_ModuleElementOperation</xsl:text>
	</xsl:template>
	
    <xsl:template match="MODULE" mode="element-script-gen-files">
    	<xsl:apply-templates select="." mode="element-script-ops" />
    	<xsl:text disable-output-escaping="yes">&amp;op=genFiles</xsl:text>
	</xsl:template>
</xsl:stylesheet>