<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/class/SVNClient.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	/*
	 * SVNClient Class
	 * 
	 * @since	2010-11-05
	 *
	*/
	
	class SVNClient
	{
		private $server_address, $repository, $username, $password;
		private $commands;
		
		function __construct($server_address='svn://91.183.60.228', $repository='officity', 
								$username='officity', $password='3800Tag427Bn888')
		{
			$this->setServer($server_address);
			$this->setRepo($repository);
			$this->setUser($username, $password);
			$this->commands = array();
		}
		
		function __destruct()
		{
		
		}
		
		/* *** */
		
		protected function execute()
		{
		    for ($i=0; $i<count($this->commands); $i++)
	    	{	
	    		$command = $this->commands[$i];
	    		$result = shell_exec($command);
	    		debug_log('SVN command: '.$command.PHP_EOL.'SVN response: '.$result);
	    		echo '<br />SVN command: '.$command;
	    		echo '<br/>SVN response: '.$result;
	    	}
	    	$this->commands = array();
		}
		
		public function setServer($server_address)
		{
			$this->server_address = $server_address;
		}
		
		public function setRepo($repository)
		{
			$this->repository = $repository;
		}
		
		public function setUser($username, $password)
		{
			$this->username = $username;
			$this->password = $password;
		}
		
		public function create($file_path, $comment='System commit (create)')
		{	      	
	    	$this->commands []= 'svn add '.$file_path.' '.$this->server_address.'/'.$this->repository;
			$this->commands []= 'svn commit '.$file_path.' --username '.$this->username.' --password '.$this->password.' -m "'.$comment.'"';
			$this->execute();
		}
		
		public function update($file_path, $comment='System commit (update)')
		{
			$this->commands []= 'svn commit '.$file_path.' --username '.$this->username.' --password '.$this->password.' -m "'.$comment.'"';
			$this->execute();
		}
		
		public function delete($file_path, $comment='System commit (delete)')
		{
	    	$this->commands []= 'svn del '.$file_path.' '.$this->server_address.'/'.$this->repository;
			$this->commands []= 'svn commit '.$file_path.' --username '.$this->username.' --password '.$this->password.' -m "'.$comment.'"';
			$this->execute();
		}
		
		public function rename($old_file_path, $new_file_path, $comment='System commit (rename)')
		{
	    	$this->commands []= 'svn add '.$new_file_path.' svn://'.$this->server_address.'/'.$this->repository;
	    	$this->commands []= 'svn del '.$old_file_path.' svn://'.$this->server_address.'/'.$this->repository;
			$this->commands []= 'svn commit '.$file_path.' --username '.$this->username.' --password '.$this->password.' -m "'.$comment.'"';
			$this->execute();
		}
		
		protected function removeSVNFolders($path)
		{
			$tmp_folder = new KernelFolder($path);
			if ($tmp_folder->exists())
			{
				$command = 'find '.$path.' -name .svn -exec rm -rf {} \;';
				$result = shell_exec($command);
	    		debug_log('Command: '.$command.PHP_EOL.'Response: '.$result);
	    		echo '<br />Command: '.$command;
	    		echo '<br/>Response: '.$result;
			}
		}
	}
?>