
/**
  * ModalDialog Class
  *
  * @author  Marc Mignonsin
  * @version 2010-12-16
*/


ModalDialog = function(panelID, controller, containerSelector, options)
{
	//window.log('ModalDialog', arguments);
	$('#'+panelID+'.panel').panel('addExternalResource', this, null);
	
	this.reset(); // just in case

	var panel = $('div#'+panelID);

	this.container = panel.find(containerSelector).eq(0);

	options.modal = true;
	options.close = delegate(this, this.close);
	
	this.container.dialog(options);
	
	return this;
};

ModalDialog.prototype.container = null;
ModalDialog.prototype.okButton = null;
ModalDialog.prototype.okButtonSelector = null;
ModalDialog.prototype.onOk = null;
ModalDialog.prototype.cancelButton = null;
ModalDialog.prototype.cancelButtonSelector = null;
ModalDialog.prototype.onCancel = null;
ModalDialog.prototype.onClose = null;
ModalDialog.prototype.HTMLContent = '';
ModalDialog.prototype.onSuccess = null;
ModalDialog.prototype.onFailure = null;

ModalDialog.prototype.reset = function()
{
	//window.log('ModalDialog.reset', arguments);
	this.container = null;
	this.okButton = null;
	this.okButtonSelector = null;
	this.onOk = null;
	this.cancelButton = null;
	this.cancelButtonSelector = null;
	this.onCancel = null;
	this.onClose = null;
	this.HTMLContent = '';
    this.onSuccess = null;
    this.onFailure = null;
};

ModalDialog.prototype.destroy = function()
{
	//window.log('ModalDialog.destroy', arguments);
	//window.log(this.container);
	if (this.okButton) this.okButton.unbind();
	if (this.cancelButton) this.cancelButton.unbind();
	this.container.dialog("destroy"); // 'destroy' doesn't automatically remove the dialog HTML content
	this.container.remove(); // ...so, we remove it manually
};

/* *** */

ModalDialog.prototype.setOkCallback = function(buttonSelector, callback)
{
	//window.log('ModalDialog.setOkCallback', arguments);
	this.okButtonSelector = buttonSelector;
	this.okButton = this.container.find(this.okButtonSelector);

	this.onOk = callback;

	this.okButton.bind('click', delegate(this, function() {
	   if (this.onOk) this.onOk();
	}));
};

ModalDialog.prototype.setCancelCallback = function(buttonSelector, callback)
{
	//window.log('ModalDialog.setCancelCallback', arguments);
	this.cancelButtonSelector = buttonSelector;
	this.cancelButton = this.container.find(this.cancelButtonSelector);

	this.onCancel = callback;

	this.cancelButton.bind('click', delegate(this, function(){
		if (this.onCancel) this.onCancel();
		this.hide();
	}));
};

ModalDialog.prototype.setCloseCallback = function(callback)
{
	//window.log('ModalDialog.setCloseCallback', arguments);
	this.onClose = callback;
};

ModalDialog.prototype.show = function()
{
	//window.log('ModalDialog.show', arguments);
	this.container.dialog("open");
};

ModalDialog.prototype.hide = function()
{
	//window.log('ModalDialog.hide', arguments);
	this.container.dialog("close");
};

ModalDialog.prototype.close = function()
{
	//window.log('ModalDialog.close', arguments);
	this.restoreHTMLContent();
	if (this.onClose) this.onClose();
};

/* *** */

ModalDialog.prototype.backupHTMLContent = function()
{
	//window.log('ModalDialog.backupHTMLContent', arguments);
	this.HTMLContent = this.container.html();
	//window.log(this.HTMLContent);
};

ModalDialog.prototype.restoreHTMLContent = function()
{
	//window.log('ModalDialog.restoreHTMLContent', arguments);
	if (this.HTMLContent == '') return;

	this.container.html(this.HTMLContent);
	this.HTMLContent = '';

	this.okButton = this.container.find(this.okButtonSelector);
	this.okButton.bind('click', delegate(this, function() {
	   if (this.onOk) return this.onOk();
	   return true;
	}));

	this.cancelButton = this.container.find(this.cancelButtonSelector);
	this.cancelButton.bind('click', delegate(this, function(){
		this.hide();
		if (this.onCancel) return this.onCancel();
		return true;
	}));
};

/* *** */

ModalDialog.prototype.setTitle = function(title)
{
	//window.log('ModalDialog.setTitle', arguments);
	this.container.dialog('option', 'title', title);
};

ModalDialog.prototype.displayWorking = function(htmlText)
{
	//window.log('ModalDialog.displayWorking', arguments);
	this.backupHTMLContent();
	htmlText = '<div align="center"><br/><br/>' + htmlText;
	htmlText += '<br /><br /><br />';
	htmlText += '<div class="ajax-loader" />';
	htmlText += '</div>';
	this.container.html(htmlText);    
};

ModalDialog.prototype.hideWorking = function(htmlText)
{
	//window.log('ModalDialog.hideWorking', arguments);
	htmlText = '<div align="center"><br/><br/>' + htmlText;
	htmlText += '<br /><br /><br />';
	htmlText += '<input type="button" id="ok-button" name="ok-button" class="modal-button" value="Close" />';
	htmlText += '<br /><br /></div>';
    
	this.container.html(htmlText);
};

ModalDialog.prototype.setSuccessCallback = function(callback)
{
	//window.log('ModalDialog.setSuccessCallback', arguments);
	this.onSuccess = callback;
};

ModalDialog.prototype.setFailureCallback = function(callback)
{
	//window.log('ModalDialog.setFailureCallback', arguments);
	this.onFailure = callback;
};

ModalDialog.prototype.displaySuccess = function(htmlText, callback)
{
	//window.log('ModalDialog.displaySuccess', arguments);
	this.hideWorking(htmlText);

    this.setSuccessCallback(callback);

	this.container.find('#ok-button').click(delegate(this, function(){
		this.hide();
        if (this.onSuccess) return this.onSuccess();
        return true;
	}));
};

ModalDialog.prototype.displayFailure = function(htmlText, callback)
{
	//window.log('ModalDialog.displayFailure', arguments);
	this.hideWorking(htmlText);

    this.setFailureCallback(callback);
	
	this.container.find('#ok-button').click(delegate(this, function(){
		this.hide();
        if (this.onFailure) return this.onFailure();
        return true;
	}));
};



