/**
  * InputsValidator Class
  *
  * @author  Marc Mignonsin
  * @version 2010-12-16
  *
  * @class InputsValidator
  * @constructor
  * @param
  */

InputsValidator = function(panelID, formSelector, submitClass, submitClassDisabled)
{
	//window.log('InputsValidator', arguments);
	$('#'+panelID+'.panel').panel('addExternalResource', this, null);
	
	this.reset(); // just in case
	
	this.panelID = panelID;
	this.setActiveForm(formSelector, submitClass, submitClassDisabled);
	this.initialize();
	
	////window.log(this);

	return this;
};

InputsValidator.prototype.panelID = null;
InputsValidator.prototype.activeForm = '';
InputsValidator.prototype.submitButton = null;
// CUSTOM
InputsValidator.prototype.requiredClass = 'required';
InputsValidator.prototype.requiredClassValid = 'required-ok';
InputsValidator.prototype.submitClass = 'input-submit-save';
InputsValidator.prototype.submitClassDisabled = 'input-submit-disabled';

InputsValidator.prototype.reset = function()
{
	//window.log('InputsValidator.reset', arguments);
	this.panelID = null;
	this.activeForm = null;
	this.submitButton = null;
	this.requiredClass = 'required';
	this.submitClass = 'input-submit-save';
};

InputsValidator.prototype.destroy = function()
{
	//window.log('InputsValidator.destroy', arguments);
};

/* *** */

InputsValidator.prototype.setActiveForm = function(formSelector, submitClass, submitClassDisabled)
{
	//window.log('InputsValidator.setActiveForm', arguments);
	//this.activeForm = $('#'+this.panelID+'.panel').find(formSelector);
	// less restrictive : allow form to be outside the panel => useful for modal dialog (e.g. system/tools/report/List.xsl) 
	this.activeForm = $(formSelector);	
	if (submitClass) 
	{
		this.submitClass = submitClass;
	}
	if (submitClassDisabled) 
	{
		this.submitClassDisabled = submitClassDisabled;
	}
	
	this.submitButton = this.activeForm.find(':input.'+this.submitClass);
	
	//window.log(this.activeForm);
	//window.log(this.submitButton);
};

InputsValidator.prototype.getActiveForm = function()
{
	//window.log('InputsValidator.getActiveForm', arguments);
	return this.activeForm;
};

InputsValidator.prototype.initialize = function()
{
    //window.log('InputsValidator.initialize', arguments);    
    var requiredElems = this.activeForm.find(':input.'+this.requiredClass+', :input.'+this.requiredClassValid);
    if (requiredElems.length == 0) return;
    
    //window.log(requiredElems);
    var self = this;  
    var formIsValid = true;
    
	requiredElems.each(function(){		
		if (self.addRequired($(this)) == false)
		{
			formIsValid = false;
		}
	});
	
	//window.log(formIsValid);
	
    if (formIsValid == false)
    {
    	this.disableSubmitButton();
    }
};

InputsValidator.prototype.addRequired = function(requiredElem, checkAll)
{
    //window.log('InputsValidator.addRequired', arguments);
    var checkResult = this.checkRequiredInput(requiredElem);
    
    if (requiredElem.is('input:file') || requiredElem.is('select'))
    {
    	requiredElem.change(delegate(this, this.checkRequired));
    }
    else if (requiredElem.is('input') || requiredElem.is('textarea')) 
	{
		requiredElem.keyup(delegate(this, this.checkRequired));			
	}
    
	if (checkAll == true) 
	{
		checkResult = this.checkRequired();
	}
	
	return checkResult;
};

InputsValidator.prototype.checkRequiredInput = function(requiredElem)
{
    //window.log('InputsValidator.checkRequiredInput', arguments);
    //window.log(jQuery.trim(requiredElem.val()) != '');
    if (jQuery.trim(requiredElem.val()) == '') 
	{		
		requiredElem.removeClass(this.requiredClassValid).addClass(this.requiredClass);
		return false;
	}
	
	requiredElem.removeClass(this.requiredClass).addClass(this.requiredClassValid);
	return true;
};

InputsValidator.prototype.checkRequired = function()
{
    //window.log('InputsValidator.checkRequired', arguments);
	var requiredElems = this.activeForm.find(':input.'+this.requiredClass+', :input.'+this.requiredClassValid);
	if (requiredElems.length == 0) return true;
	
	var formIsValid = true;
	var self = this;

    requiredElems.each(function(){
    	if (self.checkRequiredInput($(this)) == false)
    	{
    		formIsValid = false;
    	}
	});
    
    //window.log(formIsValid);
    
    if (formIsValid == false)
    {
    	this.disableSubmitButton();
    	return false;
    }
    
    this.enableSubmitButton();
    return true;
};

InputsValidator.prototype.disableSubmitButton = function()
{
    //window.log('InputsValidator.disableSubmitButton', arguments);
    this.submitButton.attr('disabled', 'disabled');
    this.submitButton.removeClass(this.submitClass).addClass(this.submitClassDisabled);
};

InputsValidator.prototype.enableSubmitButton = function()
{
    //window.log('InputsValidator.enableSubmitButton', arguments);
    this.submitButton.removeAttr('disabled');
    this.submitButton.removeClass(this.submitClassDisabled).addClass(this.submitClass);
};

InputsValidator.prototype.removeRequired = function(requiredElem, checkAll)
{
    //window.log('InputsValidator.removeRequired', arguments);
    requiredElem.removeClass(this.requiredClass+' '+this.requiredClassValid);
	if (requiredElem.is('input')) 
	{
		requiredElem.unbind('keyup');
	}
	else if (requiredElem.is('select')) 
	{
		requiredElem.unbind('change');
	}
	
	if (checkAll == true) 
	{
		return this.checkRequired();
	}
	
	return true;
};