/**
  * ajaxfileupload plugin
  *
  * Modification:   Marc Mignonsin => multiple files upload + panelID + CR/LF support + quotes support +++
  * @version 2010-12-16
  *
  */
jQuery.extend({	
	createUploadIframe: function(id, uri)
	{
		//create frame
		//window.log('ajaxFileUpload.createUploadIframe', uri);
		var frameId = 'jUploadFrame' + id;
		
		if (window.ActiveXObject) 
		{
			var io = document.createElement('<iframe id="' + frameId + '" name="' + frameId + '" />');
			if (typeof uri== 'boolean')
			{
				io.src = 'javascript:false';
			}
			else if (typeof uri== 'string')
			{
				io.src = uri;
			}
		}
		else 
		{
			var io = document.createElement('iframe');
			io.id = frameId;
			io.name = frameId;
		}
		
		io.style.position = 'absolute';
		io.style.top = '-1000px';
		io.style.left = '-1000px';

		document.body.appendChild(io);

		return io;	
	},
	createUploadForm: function(id, filesIDs, data) // Mod. by MM 16/03/2010
	{
		//window.log('ajaxFileUpload.createUploadForm', id, panelID);
		//window.log(filesIDs);
		//window.log(data);		
		var formId = 'jUploadForm' + id;
		var form = $('<form  action="" method="POST" name="' + formId + '" id="' + formId + '" enctype="multipart/form-data"></form>');	
		
        for (var k=0; k<filesIDs.length; k++) 
        {        	
            var oldElement = $('#'+data.panelID+'.panel').find('#'+filesIDs[k]);
            // MM 26/04/2010 : FIX IE 8
            var newElement = oldElement.clone(); 
            oldElement.hide();
            newElement.insertAfter(oldElement);
            oldElement.appendTo(form);
        }
        
		if (data)
		{
			for (var key in data)
			{
				if (key != 'submit') // an input named submit causes the upload to fail !!!!
				{ 
					var input = $('<textarea name="'+key+'">'+data[key]+'</textarea>');
					input.appendTo(form);
				}
			}
		}
		
		//set attributes
		form.css('position', 'absolute');
		form.css('top', '-1200px').css('left', '-1200px');
		form.appendTo('body');

        //window.log(form);

		return form;
	},

	ajaxFileUpload: function(origSettings) {
		//window.log(origSettings);
        var s = jQuery.extend(true, {}, jQuery.ajaxSettings, origSettings);// MM 2010-03-10, from jQuery-1.4.1.js
        //window.log(s);

		var id = new Date().getTime();	
		var form = jQuery.createUploadForm(id, s.filesIDs, s.data);
		var io = jQuery.createUploadIframe(id, s.secureuri);
				
		var frameId = 'jUploadFrame' + id;
		var formId = 'jUploadForm' + id;		
		// Watch for a new set of requests
		if ( s.global && ! jQuery.active++ )
		{
			jQuery.event.trigger( "ajaxStart" );
		}			
		var requestDone = false;
		// Create the request object
		var xml = {}

		if ( s.global )
			jQuery.event.trigger("ajaxSend", [xml, s]);
		// Wait for a response to come back
		var uploadCallback = function(isTimeout)
		{            
			var io = document.getElementById(frameId);
			try 
			{
				if(io.contentWindow)
				{
					 xml.responseText = io.contentWindow.document.body?io.contentWindow.document.body.innerHTML:null;
					 xml.responseXML = io.contentWindow.document.XMLDocument?io.contentWindow.document.XMLDocument:io.contentWindow.document;
					 
				}else if(io.contentDocument)
				{
					 xml.responseText = io.contentDocument.document.body?io.contentDocument.document.body.innerHTML:null;
					xml.responseXML = io.contentDocument.document.XMLDocument?io.contentDocument.document.XMLDocument:io.contentDocument.document;
				}						
			}catch(e)
			{				
				jQuery.handleError(s, xml, null, e);
			}
			if ( xml || isTimeout == "timeout") 
			{				
				requestDone = true;
				var status;
				try {
					status = isTimeout != "timeout" ? "success" : "error";
					// Make sure that the request was successful or notmodified
					if ( status != "error" )
					{
                        // MM : 2010-03-10 => add 's' parm to uploadHttpData, from jQuery-1.4.1.js		
						var data = jQuery.uploadHttpData( xml, s.dataType, s, io );

						// If a local callback was specified, fire it and pass it the data
						if ( s.success )
							s.success( data, status );
	
						// Fire the global callback
						if( s.global )
							jQuery.event.trigger( "ajaxSuccess", [xml, s] );
					} else
						jQuery.handleError(s, xml, status);
				} catch(e) 
				{
                    //window.log(e);
					status = "error";
					jQuery.handleError(s, xml, status, e);
				}

				// The request was completed
				if( s.global )
					jQuery.event.trigger( "ajaxComplete", [xml, s] );

				// Handle the global AJAX counter
				if ( s.global && ! --jQuery.active )
					jQuery.event.trigger( "ajaxStop" );

				// Process result
				if ( s.complete )
					s.complete(xml, status);

				jQuery(io).unbind()

				setTimeout(function()
									{	try 
										{
											$(io).remove();
											form.remove();
											
										} catch(e) 
										{
											jQuery.handleError(s, xml, null, e);
										}									

									}, 100)

				xml = null

			}
		}
		// Timeout checker
		if ( s.timeout > 0 ) 
		{
			setTimeout(function(){
				// Check to see if the request is still happening
				if( !requestDone ) uploadCallback( "timeout" );
			}, s.timeout);
		}
		try 
		{
		   // var io = $('#' + frameId);
			form = $('#' + formId);
			form.attr('action', s.url);
			form.attr('method', 'POST');
			form.attr('target', frameId);

			//window.log(form);
			form.submit();

		} catch(e) 
		{
			jQuery.handleError(s, xml, null, e);
		}
		if(window.attachEvent){
			document.getElementById(frameId).attachEvent('onload', uploadCallback);
		}
		else{
			document.getElementById(frameId).addEventListener('load', uploadCallback, false);
		} 		
		return {abort: function () {}};	

	},

    // MM : 2010-03-10 => adapted from jQuery-1.4.1.js
	uploadHttpData: function( xhr, type, s, io ) {
        //window.log(xhr);
        //window.log(type);
        //window.log(s);

        // trigger an error : xhr.getResponseHeader is not a function
		var ct = /*xhr.getResponseHeader("content-type") ||*/ "",
			xml = type === "xml" || !type && ct.indexOf("xml") >= 0,
			data = xml ? xhr.responseXML : xhr.responseText;

		if ( xml && data.documentElement.nodeName === "parsererror" ) {
			jQuery.error( "parsererror" );
		}
		// Allow a pre-filtering function to sanitize the response
		// s is checked to keep backwards compatibility
		if ( s && s.dataFilter ) {
			data = s.dataFilter( data, type );
		}
        
		// The filter can actually parse the response
		if ( typeof data === "string" ) {
			// Get the JavaScript object, if JSON is used.
			if ( type === "json" || !type && ct.indexOf("json") >= 0 ) {
                // hack to decode HTML entities when receiving NQL in JSON
                //$(io).append('<textarea id="htmlDecoder">'+data+'</textarea>');
                //data = $(io).find('#htmlDecoder').val();

				data = jQuery.parseJSON( data );

			// If the type is "script", eval it in global context
			} else if ( type === "script" || !type && ct.indexOf("javascript") >= 0 ) {
				jQuery.globalEval( data );
			}
		}

		return data;
	}
});

