<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/category/New.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<!-- parameters -->
	<xsl:param name="fatherID" select="/RESPONSE/URL/fatherID" />
	<xsl:param name="fatherItem" select="/RESPONSE/RESULTS[@name='fatherItem']/CATEGORY" />
	<xsl:param name="modules" select="/RESPONSE/RESULTS[@name='modules']/MODULE" />

    <xsl:param name="tabsID">
        <xsl:text>tabs-details-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>
    <xsl:param name="categInfoFormID">
        <xsl:text>form-categinfo-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel" />
    </xsl:template>
	
	<xsl:template name="panel-block-details"> 
		<xsl:attribute name="class">
			<xsl:text>block block-details extra-wide</xsl:text>
		</xsl:attribute>
		 
        <h2 class="category">
        	<xsl:text>New category</xsl:text>
        	<xsl:if test="$fatherID!=0">
	        	<xsl:text> in "</xsl:text>
	        	<xsl:apply-templates select="$fatherItem" mode="element-label" />
				<xsl:text>"</xsl:text>
			</xsl:if>
        </h2>
                        
        <!-- TABS -->
        <div id="{$tabsID}" class="tab">
	        <!-- TABS LIST -->
			<ul>
				<li>
					<a href="#{$categInfoFormID}">Infos</a>
				</li>
			</ul>
            <!-- LABEL/VALUE FORM -->
            <form id="{$categInfoFormID}" name="{$categInfoFormID}" enctype="multipart/form-data">
            	<input type="hidden" name="fatherID" id="fatherID" value="{/RESPONSE/URL/fatherID}" />
            	<input type="hidden" name="module" id="module" value="{$fatherItem/@module}" />
				<xsl:call-template name="category-content" />
            </form>
        </div>
	</xsl:template>

    <xsl:template name="category-content">
        <table class="fields">
			<xsl:choose>
				<xsl:when test="$fatherItem">					
		            <tr>
		                <td class="field-name">Module:</td>
		                <td class="field-value">
		                	<xsl:choose>
		                		<xsl:when test="$fatherItem/@module!=''">
		                    		<xsl:value-of select="$fatherItem/@module" />
		                   		</xsl:when>
		                   		<xsl:otherwise>
		                   			<xsl:text>-</xsl:text>
		                   		</xsl:otherwise>
		                    </xsl:choose>
		                </td>
		            </tr>
					<tr>
						<td class="field-name">Father path:</td>
						<td class="field-value">
							<xsl:value-of select="$fatherItem/@path" />
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td class="field-name">Module:</td>
						<td class="field-value">
							<select name="module" id="module">
								<option value="">Generic</option>
								<xsl:for-each select="$modules">
									<xsl:sort select="INFO/DENOMINATION" />
									<option value="{INFO/DENOMINATION}">
										<xsl:value-of select="INFO/DENOMINATION" />
									</option>
								</xsl:for-each>
							</select>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>            
            <tr>
                <td class="field-name">Unique name:</td>
                <td class="field-value">
                    <input type="text" class="input-text" id="uniquename" name="uniquename" value="" />
                </td>
            </tr>
            <xsl:for-each select="/RESPONSE/RESULTS[@name='published_languages']/LANGUAGE">
	            <tr>
	                <td class="field-name"><xsl:value-of select="LABEL" />:</td>
	                <td class="field-value">	                    
                        <input type="text" class="input-text" id="label-{@ID}" name="label-{@ID}" value="" />
	                </td>
	            </tr>
            </xsl:for-each>
            <tr>
                <td class="field-name">Assignable:</td>
                <td class="field-value">
                    <input type="checkbox" class="input-checkbox" value="1" id="isassignable" name="isassignable" checked="checked" />
                </td>
            </tr>
            <tr>
                <td class="field-name">&#160;</td>
                <td class="field-value">
                    <input type="submit" id="submit-button" name="submit-button" class="input-submit-save" value="Create"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template name="panel-js">
		<xsl:call-template name="js-init-tabs" />

           <!-- PROCESS -->
		$('#<xsl:value-of select="$categInfoFormID" />').submit(delegate(this, function() {
               fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);

			fm.onSuccess(function(response){
               <xsl:text>$(AppController).panelslider('replacePanel', </xsl:text>
                   <xsl:value-of select="$panelID"/>
                   <xsl:text>,'../../system/tools/category/New','New category',</xsl:text>
                   <xsl:text>{fatherID:response.fatherID}</xsl:text>
               <xsl:text>, 1);</xsl:text>
			});

            fm.displayProcess('Adding category...');
            fm.setScript('../../system/tools/category/ops.php?action=create');
			fm.parseAndSend('#<xsl:value-of select="$categInfoFormID" />');

			return false;
		}));
    </xsl:template>
</xsl:stylesheet>