<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/category/ops.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');
	
	/* *** */
	
	function getLabelsNQL()
	{
        $labels_NQL = '';
        foreach ($_POST as $key => $value)
        {
        	list($label_prefix, $lang_ID) = explode('-', $key, 2);	
        	if ($label_prefix != 'label') continue;
        	$labels_NQL .= '<LABEL languageID="'.$lang_ID.'">'.encode_to_xml($value).'</LABEL>';
        }
        return $labels_NQL;
	}
	
	/* *** */

    $response = new JSONResponse();
    $response->set('object', 'CATEGORY');

    $ACTION = $_GET['action'];
	if (!in_array($ACTION, array('create', 'update', 'delete'/*, 'import'*/)))
	{
        $response->outputError('Invalid action "'.$ACTION.'"!');
	}
    $response->set('action', $ACTION);
		    
    /* *** */

    $result = false;
    $output_message = '';
    
    $nql = new Officity_Shell();

    switch ($ACTION)
    {
        case 'create':
		    if (!isset($_POST['fatherID']))
		    {
		    	$response->outputError('No father ID!');
		    }
		    $FATHER_ID = $_POST['fatherID'];
		    $response->set('fatherID', $FATHER_ID);
    
		    $UNIQUENAME = $_POST['uniquename'];
		    if (empty($UNIQUENAME))
		    {
		    	$response->outputError('No unique name!');
		    }
		    $response->set('uniquename', $UNIQUENAME);
		    
		    $ISASSIGNABLE = $_POST['isassignable'];
		    
		  	$MODULE = $_POST['module'];
		    $response->set('module', $MODULE);
    
        	$labels_NQL = getLabelsNQL();        	
        	$nql_command = '
        		<CREATE>
        			<CATEGORY fatherID="'.$FATHER_ID.'" module="'.$MODULE.'">
        				<UNIQUENAME>'.$UNIQUENAME.'</UNIQUENAME>
        				<ISASSIGNABLE>'.$ISASSIGNABLE.'</ISASSIGNABLE>
        				'.$labels_NQL.'
        			</CATEGORY>
        		</CREATE>
        	';
        	$nql->addCommand($nql_command);
        	//var_dump($nql_command);
        	//die();
            break;

        case 'update':		    
		    if (!isset($_POST['fatherID']))
		    {
		    	$response->outputError('No father ID!');
		    }
		    $FATHER_ID = $_POST['fatherID'];
		    $response->set('fatherID', $FATHER_ID);
		    
		    $ID = $_POST['ID'];
		    if (empty($ID))
		    {
		    	$response->outputError('No ID!');
		    }
		    $response->set('ID', $ID);
		    
		    $ISASSIGNABLE = $_POST['isassignable'];
    
        	$labels_NQL = getLabelsNQL();  
        	$nql_command = '
        		<UPDATE>
        			<CATEGORY fatherID="'.$FATHER_ID.'" ID="'.$ID.'">
        				<ISASSIGNABLE>'.$ISASSIGNABLE.'</ISASSIGNABLE>
        				'.$labels_NQL.'
        			</CATEGORY>
        		</UPDATE>
        	';
        	$nql->addCommand($nql_command);
        	//var_dump($nql_command);
        	//die();
            break;

        case 'delete':
		    $ID = $_POST['ID'];
		    if (empty($ID))
		    {
		    	$response->outputError('No ID!');
		    }
		    $response->set('ID', $ID);
		    
        	$nql_command = '
        		<DELETE>
        			<CATEGORY ID="'.$ID.'" child_action="delete"/>
        		</DELETE>
        	';
        	$nql->addCommand($nql_command);
        	//var_dump($nql_command);
        	//die();
            break;

        /*case 'import':
            break;*/

        default:
            break;
    }
    
    if ($nql->execute() == true)
    {
    	$message = $nql->getElement("/RESPONSE/MESSAGE");    	
		if ($message->valueOf("@msgType") == '0')
		{			
			$result = true;
		}
		else
		{
			$output_message = $message->valueOf();
		}
    }

	if ($result === true)
	{
        $response->outputSuccess($output_message);
	}
    else
	{
        $response->outputError('Action failed: '.$output_message);
	}
?>