<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/element/Link.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');
	
	// editor's display
    $shell = new Officity_Shell();

	$element = ElementFactory::build(URLParam::fetch('targetModule'));

	if (URLParam::isNotEmpty('quicksearch-text'))
	{
		$element->addSearchInfo('SEARCHTEXT', 'MATCH', URLParam::fetch('quicksearch-text'));
	}
	else
	{
		$element->setDependencyByName(URLParam::fetch('dependency'), URLParam::fetch('module'), URLParam::fetch('originID'), 'reverse', '');
	}

    $element->setDisplayProfile(); // return needed for display
	$element->addSharedResourcesCommands($shell); // resources needed for display
	$element->setDefaultPaginate(URLParam::fetch('display', 50), URLParam::fetch('page', 1));
	$element->search('list', false);

	$search_command = $element->getNQLCommand();
	$shell->addCommand($search_command);
	
	/* *** */

    $dep_element = ElementFactory::build(URLParam::fetch('targetModule'));
    
    $dep_element->setDependencyByName(URLParam::fetch('dependency'), URLParam::fetch('module'), URLParam::fetch('originID'), 'reverse', '');
    
    $dep_element->setNoReturn();
    $dep_element->search('depsList', false);

    $search_command = $dep_element->getNQLCommand();
	$shell->addCommand($search_command);
	
	/* *** */

	$shell->addPaging();
    
    echo $shell->transform(dirname(__FILE__).'/Link.xsl');
?>