<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/field/field.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <!-- LABEL(s) -->
	<xsl:template match="FIELD" mode="element-label">
        <xsl:value-of select="INFO/DENOMINATION"/>
        <xsl:text> (</xsl:text>
        <xsl:apply-templates select="INFO/TYPE" mode="display-value" />
        <xsl:text>)</xsl:text>
	</xsl:template>

	<xsl:template match="FIELD[INFO/TYPE='list']" mode="element-label">
        <xsl:value-of select="INFO/DENOMINATION"/>
        <xsl:text> (</xsl:text>
        <xsl:apply-templates select="INFO/TYPE" mode="display-value" />
        <xsl:text> : </xsl:text>
        <xsl:apply-templates select="INFO/LISTNAME" mode="display-value" />
        <xsl:text>)</xsl:text>
	</xsl:template>

	<!-- ICON(s) -->
	<xsl:template match="FIELD" mode="element-icon">
		<xsl:text>../system/images/icons/fields/field-16.png</xsl:text>
	</xsl:template>

	<xsl:template match="FIELD[INFO/SEARCHABLE=1]" mode="element-icon">
		<xsl:text>../system/images/icons/fields/searchable-16.png</xsl:text>
	</xsl:template>

	<!-- INFO LABEL(s) -->

	<!-- NAVIGATION ITEM(s) -->
	
	<!-- TITLE(s) -->
	<xsl:template match="FIELD" mode="element-title">        
		<h2 class="field">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
	
	<xsl:template match="FIELD[INFO/SEARCHABLE=1]" mode="element-title">        
		<h2 class="field-searchable">
			<xsl:apply-templates select="." mode="element-label"/>
		</h2>
	</xsl:template>
	
	<!-- SCRIPTS -->

	<!-- MISC (for forms) -->
    <xsl:template match="FIELD" mode="field-name">
        <xsl:choose>
            <xsl:when test="DESCRIPTIONS/DESCRIPTION/TITLE/text()">
                <xsl:value-of select="DESCRIPTIONS/DESCRIPTION/TITLE"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="INFO/DENOMINATION"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="FIELD" mode="field-shortname">
        <xsl:choose>
            <xsl:when test="DESCRIPTIONS/DESCRIPTION/SUMMARY/text()">
                <xsl:value-of select="DESCRIPTIONS/DESCRIPTION/SUMMARY"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="INFO/DENOMINATION"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>