<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/filter/save-default.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');

    /* *** */
	
	function checkCommandResult(&$nql, &$response, $update=false)
	{
		$message = $nql->getElement("/RESPONSE/MESSAGE");
		if (($message === false) || ($message->valueOf("@msgType") != '0'))
		{
			$msg = ($message) ? ' '.$message->valueOf('.') : '';
			$op = ($update == false) ? 'Creation' : 'Update';
			$response->outputError($op.' report error: '.$msg);
		}
	}
	
	/* *** */

    $response = new JSONResponse();
    $response->set('module', 'OFFICITY:FILTER');

    $TARGET_MODULE = URLParam::fetch('module');
    $response->set('module', $TARGET_MODULE);

    /* 1st: build and save display filter */

    $element = new Element($TARGET_MODULE);
   
    $columns = explode(',', URLParam::fetch('columns'));
    $element->setSearchReturn($columns);
    $element->setSort(URLParam::fetch('sort'), URLParam::fetch('order'));
    $element->setDefaultPaginate(URLParam::fetch('display'));
	
    $filter = $element->buildSearchFilter();

    $filter->setInfo('DEFAULT', 1);
    $filter->setInfo('MODULE', $TARGET_MODULE);
    $filter->setInfo('DENOMINATION', 'Default '.URLParam::fetch('label').' display');
	$filter->setInfo('OWNERID', 0);

    $filter->setInfo('ISQUERY', 0);
    $filter->setInfo('ISDISPLAY', 1);
	$filter->setInfo('COUNT', 0);
	$filter->setInfo('SEARCH', 0);

    //$filter->logCommand();

    // filter update?
    $FILTER_ID = URLParam::fetch('ID', null);    
	if (!empty($FILTER_ID))
    {	
        $response->set('ID', $FILTER_ID);
        $filter->setInfo('ID', $FILTER_ID);
        
        if ($filter->update() == false)
        {      
            $response->outputError('Filter update failed: '.$filter->getLastError());
        }
	}
    else // create new filter
    {
        if ($filter->create() == false)
        {
            $response->outputError('Filter creation failed: '.$filter->getLastError());            
        }
        $response->set('ID', $filter->getID());
    }
    
    $nql = new Sushee_Shell(false);
    
    /* 2nd: search config */
    $SEARCHCONFIG_ID = URLParam::fetch('searchConfigID', null);    
    if (empty($SEARCHCONFIG_ID))
    {
    	$nql->addCommand('
    		<CREATE>
    			<OFFICITY:SEARCHCONFIG>
    				<INFO>
    					<MODULE>'.$TARGET_MODULE.'</MODULE>
    					<DEFAULT>1</DEFAULT>
    					<CONFIGXML>
	    					<MODULE>'.$TARGET_MODULE.'</MODULE>
	    					<MODULEDESC>'.URLParam::fetch('label').'</MODULEDESC>
							<DEFAULTFIELD>ID</DEFAULTFIELD>
							<DEFAULTOPERATOR>=</DEFAULTOPERATOR>
							<DEFAULTOPERANDS/>
    					</CONFIGXML>
    				</INFO>
    			</OFFICITY:SEARCHCONFIG>
    		</CREATE>
    	');	
	    	
    	$nql->execute();
    	checkCommandResult($nql, $response);
    }
    else 
    {
    	$update_command = '
    		<UPDATE>
    			<OFFICITY:SEARCHCONFIG ID="'.$SEARCHCONFIG_ID.'">
    				<INFO>
    					<CONFIGXML>
	    					<MODULE>'.$TARGET_MODULE.'</MODULE>
	    					<MODULEDESC>'.URLParam::fetch('label').'</MODULEDESC>
							<DEFAULTFIELD>ID</DEFAULTFIELD>
							<DEFAULTOPERATOR>=</DEFAULTOPERATOR>
							<DEFAULTOPERANDS/>
							<DEPENDENCIES>
    	';	
    	$i = 0;
    	foreach ($_POST['depsData'] as $data) 
    	{
	    	$update_command .= '
									<DEPENDENCY order="'.($i++).'">
										<TYPE>'.$data['type'].'</TYPE>
										<MODULE>'.$data['module'].'</MODULE>
										<MODULEDESC>'.$data['moduledesc'].'</MODULEDESC>
										<DESC>'.$data['searchdesc'].'</DESC>
										<DEFAULTFIELD>SEARCHTEXT</DEFAULTFIELD>
										<DEFAULTOPERATOR>MATCH</DEFAULTOPERATOR>
										<DEFAULTOPERANDS />
									</DEPENDENCY>
	    	';	
    	}
    	$update_command .= '
							</DEPENDENCIES>
    					</CONFIGXML>
    				</INFO>
    			</OFFICITY:SEARCHCONFIG>
    		</UPDATE>
    	';	
    	
    	//die($update_command);
    	
    	$nql->addCommand($update_command);
	    	
    	$nql->execute();
    	checkCommandResult($nql, $response);
    }
    
    /* 3rd: default reports */
    
    $display_xml = '<DISPLAYXML>'.$filter->getDisplayString().'</DISPLAYXML>';
    $REPORTS_IDS = URLParam::fetch('reportsIDs', null);
    
    // create?
    if (empty($REPORTS_IDS))
    {
    	// PDF report
    	$nql->addCommand('
    		<CREATE>
    			<OFFICITY:REPORT>
    				<INFO>
    					<MODULE>'.$TARGET_MODULE.'</MODULE>
    					<MODEL>1</MODEL>
    					<OWNERID>0</OWNERID>
    					<TYPE>pdf</TYPE>
    					<FORMAT>A4</FORMAT>
    					<ORIENTATION>portrait</ORIENTATION>
    					<APPLY>search</APPLY>
    					<TITLE>Basic report</TITLE>
    					'.$display_xml.'
    				</INFO>
    			</OFFICITY:REPORT>
    		</CREATE>
    	');	
    	$nql->execute();
    	checkCommandResult($nql, $response);
    	
    	// CSV export
    	$nql->addCommand('
    		<CREATE>
    			<OFFICITY:REPORT>
    				<INFO>
    					<MODULE>'.$TARGET_MODULE.'</MODULE>
    					<MODEL>1</MODEL>
    					<OWNERID>0</OWNERID>
    					<TYPE>csv</TYPE>
    					<FORMAT>A4</FORMAT>
    					<ORIENTATION>portrait</ORIENTATION>
    					<APPLY>search</APPLY>
    					<TITLE>Export</TITLE>
    					'.$display_xml.'
    				</INFO>
    			</OFFICITY:REPORT>
    		</CREATE>
    	');	
    	$nql->execute();
    	checkCommandResult($nql, $response);
    	
    	$nql->addCommand('
    		<CREATE>
    			<OFFICITY:REPORT>
    				<INFO>
    					<MODULE>'.$TARGET_MODULE.'</MODULE>
    					<MODEL>1</MODEL>
    					<OWNERID>0</OWNERID>
    					<TYPE>csv</TYPE>
    					<FORMAT>A4</FORMAT>
    					<ORIENTATION>portrait</ORIENTATION>
    					<APPLY>all</APPLY>
    					<TITLE>Extended export</TITLE>
    					<TEMPLATE>csv/generic-csv-export-alt.xsl</TEMPLATE>
    					'.$display_xml.'
    				</INFO>
    			</OFFICITY:REPORT>
    		</CREATE>
    	');	
    	$nql->execute();
    	checkCommandResult($nql, $response);
    }
    else // update
    {
    	$nql->addCommand('
    		<UPDATE>
    			<OFFICITY:REPORT>
    				<INFO>
    					'.$display_xml.'
    				</INFO>
	    			<WHERE>
	    				<INFO>
	    					<ID operator="IN">'.$REPORTS_IDS.'</ID>
	    				</INFO>
	    			</WHERE>
    			</OFFICITY:REPORT>
    		</UPDATE>
    	');
    	$nql->execute();
    	checkCommandResult($nql, $response, true);
    }
    
    $response->outputSuccess();
?>