<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/followup/List.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com" xmlns:IPA="http://www.ipa.org.uk/">
	<xsl:import href="include.xsl"/>	
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>

	<!-- parameters -->
	<xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
	<xsl:param name="noteFormID">
		<xsl:text>form-followup-</xsl:text>
		<xsl:value-of select="$panelID"/>
	</xsl:param>
	
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel">
    	</xsl:call-template>
    </xsl:template>
    
   	<xsl:template name="panel-header">
		<div class="block block-details block-details-followups">
			<a id="write-note" class="write" href="#" title="Leave a note...">
				<xsl:text>Leave a note...</xsl:text>
			</a>
			<form id="{$noteFormID}" name="{$noteFormID}" method="POST" style="display:none;">
				<input type="hidden" name="ID" value="{$item/@ID}"/>
				<input type="hidden" name="module" value="{name($item)}"/>
	
				<table class="fields">
					<tr>
						<td class="field-name">Note: </td>
						<td class="field-value">
							<textarea id="info-OFFICITY__FOLLOWUP-BODY" name="info-OFFICITY__FOLLOWUP-BODY" class="input-textarea">
								<xsl:choose>
									<xsl:when test="/RESPONSE/URL/requestID">
										<xsl:text>Dear </xsl:text>
										<!--xsl:value-of select="/RESPONSE/URL/recipientName"/-->
										<xsl:text>,</xsl:text>
										<xsl:text>&#13;&#13;&#13;&#13;</xsl:text>
										<xsl:value-of select="/RESPONSE/URL/userName"/>
										<xsl:text>.</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:comment></xsl:comment>
									</xsl:otherwise>
								</xsl:choose>
							</textarea>
						</td>
					</tr>
					<tr>
						<td class="field-name">File:</td>
						<td class="field-value">
							<input type="file" class="input-file" id="info-OFFICITY__FOLLOWUP-FILE" name="info-OFFICITY__FOLLOWUP-FILE"/>
						</td>
					</tr>
					<tr>
						<td class="field-name">&#160;</td>
						<td class="field-value">&#160;</td>
					</tr>
					<tr>
						<td class="field-name"></td>
						<td class="field-value">
							<input id="add-button" type="submit" class="input-submit-save" value="Add note" style="float:left;"/>
							<xsl:if test="/RESPONSE/RESULTS[@name='SupportTeam']/CONTACT[@ID=$userID]">
								<input id="add-internal-button" type="button" class="input-submit-save" value="Add internal note" style="float:right;"/>
							</xsl:if>
						</td>
					</tr>
				</table>
			</form>
		</div>
    </xsl:template>
    
    <xsl:template name="panel-body">
		<div class="block block-details block-details-followups">
			<ul>
				<xsl:choose>
					<xsl:when test="/RESPONSE/RESULTS[@name='SupportTeam']/CONTACT[@ID=$userID]">
						<xsl:choose>
							<xsl:when test="count(/RESPONSE/RESULTS[@name='followups']/*) > 0">
								<xsl:for-each select="/RESPONSE/RESULTS[@name='followups']/*">
									<xsl:sort select="INFO/CREATIONDATE" order="descending"/>
									<xsl:apply-templates select="." mode="element-detail" />
								</xsl:for-each>
				            </xsl:when>
					            <xsl:otherwise>
					                <div class="no-result">No followups</div>
					            </xsl:otherwise>
				        </xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="count(/RESPONSE/RESULTS[@name='followups']/*) > 0">
								<xsl:for-each select="/RESPONSE/RESULTS[@name='followups']/*[INFO/TYPE!='internal']">
									<xsl:sort select="INFO/CREATIONDATE" order="descending"/>
									<xsl:apply-templates select="." mode="element-detail" />
								</xsl:for-each>			
			            	</xsl:when>
					            <xsl:otherwise>
					                <div class="no-result">No followups</div>
					            </xsl:otherwise>
				        </xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</ul>
		</div>
    </xsl:template>
    
    <xsl:template name="panel-js">
    	$('#<xsl:value-of select="$panelID"/>.panel').find('#write-note').click(function(){
			$(this).hide();
			$('#<xsl:value-of select="$panelID"/>.panel #<xsl:value-of select="$noteFormID"/>').slideToggle('fast', function(){
				$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-layout');
			});
			return false;
    	});
    	
		$('#<xsl:value-of select="$panelID"/>.panel #<xsl:value-of select="$noteFormID"/>').submit(function(){
		    fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
		
			fm.onSuccess(function(response){
		        $(AppController).panelslider('reloadPanel', <xsl:value-of select="$panelID"/>);
			});
		
		    fm.displayProcess('Adding note...');
		    fm.setScript('<xsl:value-of select="$systemToolsURL"/>followup/create.php');
			fm.parse('#<xsl:value-of select="$noteFormID"/>');
			fm.addData('info-OFFICITY:FOLLOWUP-TYPE', 'crm');
			fm.send();

			return false;
		});

		$('#<xsl:value-of select="$panelID"/>.panel #<xsl:value-of select="$noteFormID"/> #add-internal-button').click(function(){
		    fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
		
			fm.onSuccess(function(response){
		        $(AppController).panelslider('reloadPanel', <xsl:value-of select="$panelID"/>);
			});
		
		    fm.displayProcess('Adding internal note...');
		    fm.setScript('<xsl:value-of select="$systemToolsURL"/>followup/create.php');				
			fm.parse('#<xsl:value-of select="$noteFormID"/>');
			fm.addData('info-OFFICITY:FOLLOWUP-TYPE', 'internal');
			fm.send();
			return false;
		});
    </xsl:template>
</xsl:stylesheet>
