<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/module/Fields.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="fields" select="//FIELD" />

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
    <xsl:template name="panel-title">
		<xsl:call-template name="truncate-phrase">
			<xsl:with-param name="phrase">
                <xsl:text>FIELDS : </xsl:text>
                <xsl:value-of select="/RESPONSE/URL/module" />  
			</xsl:with-param>
		</xsl:call-template>
    </xsl:template>  
	
	<xsl:template name="panel-body-navigation">  
		<xsl:call-template name="navigationitem">
		    <xsl:with-param name="title">
		        <xsl:text>Dependencies browser</xsl:text>
		    </xsl:with-param>
		    <xsl:with-param name="panelURI">../../system/tools/module/Dependencies</xsl:with-param>
		    <xsl:with-param name="params">
		        <xsl:text>module:'</xsl:text>
		        <xsl:value-of select="/RESPONSE/URL/module"/>
		        <xsl:text>'</xsl:text>
		    </xsl:with-param>
		    <xsl:with-param name="icon">
		        <xsl:text>../system/images/icons/dependencies/link-16.png</xsl:text>
		    </xsl:with-param>
		    <xsl:with-param name="cssclass">grey-bkgnd</xsl:with-param>
		    <xsl:with-param name="info">
		    </xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationitem">
		    <xsl:with-param name="id">instances-count<xsl:value-of select="$panelID"/></xsl:with-param>
		    <xsl:with-param name="title">Elements browser</xsl:with-param>
		    <xsl:with-param name="panelURI">../../system/tools/element/RawQuickSearch</xsl:with-param>
		    <xsl:with-param name="params">
		        <xsl:text>module:'</xsl:text>
		        <xsl:value-of select="/RESPONSE/URL/module"/>
		        <xsl:text>'</xsl:text>
		    </xsl:with-param>
		    <xsl:with-param name="icon">
		        <xsl:text>../system/images/icons/modules/generic.png</xsl:text>
		    </xsl:with-param>
		    <xsl:with-param name="cssclass">grey-bkgnd</xsl:with-param>
		    <xsl:with-param name="displayCount" select="true()"/>
		</xsl:call-template>
		<xsl:call-template name="nav-new">
		    <xsl:with-param name="title">Create new <xsl:value-of select="/RESPONSE/URL/module"/></xsl:with-param>
		    <xsl:with-param name="module" select="/RESPONSE/URL/module"/>
		    <xsl:with-param name="cssclass">grey-bkgnd</xsl:with-param>
		</xsl:call-template>
		
		<xsl:for-each select="$fields">
		    <xsl:sort select="INFO/DENOMINATION" />
		    <xsl:apply-templates select="." mode="element-navitem" />
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="panel-js-navigation"> 
	    var countRequest<xsl:value-of select="$panelID"/> = new AjaxRequest(
	        <xsl:value-of select="$panelID"/>,
	        AppController,
	        '<xsl:value-of select="$systemToolsURL"/>element/call-element-operation.php',
	        'GET'
	    );
	
	    countRequest<xsl:value-of select="$panelID"/>.addData('op', 'count');
	    countRequest<xsl:value-of select="$panelID"/>.addData('module', '<xsl:value-of select="/RESPONSE/URL/module"/>');
	
	    countRequest<xsl:value-of select="$panelID"/>.onSuccess(function(response){
	        $('#instances-count<xsl:value-of select="$panelID"/> .info').html(response.message+' element(s)');
	    }).send(); 
	</xsl:template>
</xsl:stylesheet>