<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.error.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>

	<!--  ERROR PANEL -->
	<xsl:template name="panel-error">
		<xsl:param name="optimalWidth" />
		<xsl:param name="fixedHeaderHeight" />
		<xsl:param name="fixedBodyHeight" />
		<xsl:param name="errorNode" select="/RESPONSE/RESULTS[@name='errorMessage']" />
		<xsl:param name="bodyOnly" select="false()"/>
		
		<xsl:if test="$bodyOnly=false()">
			<div class="panel-title-bar">
				<xsl:call-template name="panel-title-bar"/>
			</div>
	        <div class="panel-header">
	        	<xsl:if test="$fixedHeaderHeight!=''">
	        		<xsl:attribute name="style">
	        			<xsl:text>height:</xsl:text>
	        			<xsl:value-of select="$fixedHeaderHeight" />
	        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
	        		</xsl:attribute>
	        	</xsl:if>
	        	<xsl:call-template name="panel-header"/>
	       	</div>
       	</xsl:if>
       	<div class="panel-body" optimal-width="{$optimalWidth}">
        	<xsl:if test="$fixedBodyHeight!=''">
        		<xsl:attribute name="style">
        			<xsl:text>height:</xsl:text>
        			<xsl:value-of select="$fixedBodyHeight" />
        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
        		</xsl:attribute>
        	</xsl:if>
        	<xsl:call-template name="panel-body-loader"/>
        	<xsl:call-template name="panel-body-error">
        		<xsl:with-param name="errorNode" select="$errorNode" />
        	</xsl:call-template>
        </div>
        <xsl:if test="$bodyOnly=false()">
	        <script type="text/javascript">
	        	<xsl:call-template name="panel-js"/>
	        	<xsl:call-template name="panel-add-js"/>
	        </script>
        </xsl:if>
    </xsl:template>
    
    <!-- error body -->
    <xsl:template name="panel-body-error">
    	<xsl:param name="errorNode" />
    
		<div class="block-error">
			<xsl:attribute name="class">
				<xsl:text>block-error </xsl:text>
					<xsl:value-of select="$errorNode/CLASS" />
				</xsl:attribute>
               <div id="error-msg">
                   <h1><xsl:copy-of select="$errorNode/TITLE/node()"/></h1>
                  <p><xsl:copy-of select="$errorNode/MESSAGE/node()"/></p>
	           </div>
           </div>
    </xsl:template>
</xsl:stylesheet>