<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.events.js.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- bind delete event to panel -->
	<xsl:template name="panel-bind-delete-event">	
	    $('#<xsl:value-of select="$panelID"/>.panel').bind('deleteitem', function(eventObject, actionElem, ID, actionScript){	        
	        var actionElem = $(actionElem);
	        var navItem = actionElem.closest('div.items');
	        var actionsLabel = navItem.find('div.actions-label');
	        if (!actionElem.hasClass('confirm'))
	        {
	            actionElem.addClass('confirm');
	            actionsLabel.html('Confirm?');
	            return false;
	        }
	        if (actionElem.hasClass('ajax-loader'))
	        {
	        	return false;
        	
        	}
			actionElem.removeClass('delete-action').addClass('ajax-loader');
	
	        var deleteRequest = new AjaxRequest(
	            <xsl:value-of select="$panelID"/>,
	            AppController,
	            actionScript,
	            'POST',
	            'json'
	        );
	
	        deleteRequest.addData('ID', ID);
	
	        // no error dialog and return errors in short msgs format
	        deleteRequest.errorDialog(false, true);
	        deleteRequest.internalErrorDialog(false, true); 
	
	        deleteRequest.onSuccess(function(response){
	           navItem.fadeOut(200, function(){ 
					    $(this).remove();
					});
	        }).onError(function(response){
	            actionElem.removeClass('ajax-loader').addClass('delete-action');
	            actionsLabel.html(response.message);
	        }).send();
	
	        return false;
	    });
	</xsl:template>
	
	<!-- bind the update dependency event to panel -->
	<xsl:template name="panel-bind-dependency-event">	
		<xsl:param name="dependency" />
		<xsl:param name="targetModule" />
		<xsl:param name="targetID" />
		<xsl:param name="callback" />
		
	    $('#<xsl:value-of select="$panelID"/>.panel').bind('updatedependency', function(eventObject, actionElem, ID, actionScript, dependency, targetModule, targetID){
	        var actionElem = $(actionElem);
	        var navItem = actionElem.closest('div.items');
	        var actionsLabel = navItem.find('div.actions-label');
	        if (!actionElem.hasClass('confirm'))
	        {
	            actionElem.addClass('confirm');
	            actionsLabel.html('Confirm?');
	            return false;
	        }
	        if (actionElem.hasClass('ajax-loader'))
	        {
	        	return false;
        	
        	}
        	var actionClass = actionElem.attr('class');
			actionElem.removeClass(actionClass).addClass('ajax-loader');
	
	        var updateRequest = new AjaxRequest(
	            <xsl:value-of select="$panelID"/>,
	            AppController,
	            actionScript,
	            'POST',
	            'json'
	        );
	
	        updateRequest.setData({ 
	            ID : ID,
	            dependency : '<xsl:value-of select="$dependency"/>',
	            targetModule : '<xsl:value-of select="$targetModule"/>',
	            targetID : '<xsl:value-of select="$targetID"/>'
	        });
	
	        // no error dialog and return errors in short msgs format
	        updateRequest.errorDialog(false, true);
	        updateRequest.internalErrorDialog(false, true);
	
	        updateRequest.onSuccess(function(response){
        		<xsl:choose>
        			<xsl:when test="$callback">
           				<xsl:value-of select="$callback" />
          			</xsl:when>
					<xsl:otherwise>
						if (actionClass.indexOf('unlink-action') == -1)
						{
							$('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-refresh');
						}
						else
						{
			           		navItem.fadeOut(200, function(){ 
							    $(this).remove();
							});
						}
					</xsl:otherwise>
           		</xsl:choose>
	        }).onError(function(response){
	            actionElem.removeClass('ajax-loader').addClass(actionClass);
	            navItem.find('.actions-label').html(response.message);
	        }).send();
	
	        return false;
	    });
	</xsl:template>
</xsl:stylesheet>