<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.generic.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
	
	<!-- GENERIC PANEL : skeleton -->
	<xsl:template name="panel">
		<xsl:param name="optimalWidth" />
		<xsl:param name="fixedHeaderHeight" select="''" />
		<xsl:param name="fixedBodyHeight" select="''" />
		<xsl:param name="panelcssclass" />
		
		<div class="panel-title-bar">
			<xsl:call-template name="panel-title-bar"/>
		</div>
        <div class="panel-header">
        	<xsl:if test="$fixedHeaderHeight!=''">
        		<xsl:attribute name="style">
        			<xsl:text>height:</xsl:text>
        			<xsl:value-of select="$fixedHeaderHeight" />
        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
        		</xsl:attribute>
        	</xsl:if>
        	<xsl:call-template name="panel-header"/>
       	</div>
       	<div class="panel-body" optimal-width="{$optimalWidth}">
        	<xsl:if test="$fixedBodyHeight!=''">
        		<xsl:attribute name="style">
        			<xsl:text>height:</xsl:text>
        			<xsl:value-of select="$fixedBodyHeight" />
        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
        		</xsl:attribute>
        	</xsl:if>
       		<xsl:call-template name="panel-body"/> 
        	<xsl:call-template name="panel-body-loader"/>
        </div>
        <script type="text/javascript">
        	<xsl:call-template name="panel-js">
        		<xsl:with-param name="panelcssclass" select="$panelcssclass"/>
        	</xsl:call-template>
        	<xsl:call-template name="panel-add-js"/>
        </script>
    </xsl:template>
    
	<!--  title bar -->
	<xsl:template name="panel-title-bar">
		<xsl:param name="displayOptions" />
		
		<xsl:if test="$displayOptions=true()">
			<xsl:attribute name="class">
				<xsl:text>panel-title-bar panel-title-bar-options</xsl:text>
			</xsl:attribute>
		</xsl:if>
	
		<table>
			<tr>
				<td class="left-toolbar">
					<a class="tool nav-prev tool-off" title="Go to the previous panel" href="#">
						<xsl:attribute name="onclick">
							if ($(this).hasClass('tool-off')) return false;
							<xsl:text>$(AppController).panelslider('previousPanel',</xsl:text>
							<xsl:value-of select="$panelID" />
							<xsl:text>);</xsl:text>
						</xsl:attribute>
					</a>
				</td>
				<td class="center">
					<div class="title no-selection" panel-rel-path="{/RESPONSE/URL/editor}/{/RESPONSE/URL/app}/{/RESPONSE/URL/panelURI}">
		      			<xsl:call-template name="panel-title"/>
		      		</div>
				</td>
				<td class="right-toolbar">
					<a class="tool nav-next tool-off" title="Go to the next panel" href="#">
						<xsl:attribute name="onclick">
							if ($(this).hasClass('tool-off')) return false;
							<xsl:text>$(AppController).panelslider('nextPanel',</xsl:text>
							<xsl:value-of select="$panelID" />
							<xsl:text>);</xsl:text>
						</xsl:attribute>		
					</a>
				</td>
			</tr>
			<tr>
				<td class="left-toolbar">
					<a class="tool new-tab" title="Open this panel in a new tab" href="#">
						<xsl:attribute name="onclick">
							if ($(this).hasClass('tool-off')) return false;
							<xsl:text>$(AppController).panelslider('newTabPanel', </xsl:text>
							<xsl:value-of select="$panelID" />
							<xsl:text>, '</xsl:text>
							<xsl:value-of select="/RESPONSE/URL/appsURL" />
							<xsl:value-of select="/RESPONSE/URL/editor" />
							<xsl:text>/</xsl:text>
							<xsl:value-of select="/RESPONSE/URL/app" />
							<xsl:text>/</xsl:text>
							<xsl:text>', {</xsl:text>
		                        <xsl:for-each select="/RESPONSE/URL/*[name()!='rootURL' and
		                        										name()!='appsURL' and
		                        										name()!='systemURL' and
		                        										name()!='systemToolsURL' and
		                        										name()!='systemImagesURL' and
		                        										name()!='editorURL' and
		                        										name()!='sharedURL' and
		                        										name()!='sharedImagesURL' and
		                        										name()!='appURL' and
		                        										name()!='appImagesURL' and
		                        										name()!='panelID' and
		                        										name()!='parentID' and
		                        										name()!='tabSessionID' and
		                        										name()!='userID' and
		                        										name()!='now' and
		                        										name()!='appName' and
		                        										name()!='appFolder' and
		                        										name()!='editorName' and
		                        										name()!='editorFolder'
		                        										]">
		                            <xsl:text>"</xsl:text>
		                            <xsl:value-of select="name(.)" />
		                            <xsl:text>"</xsl:text>
		                            <xsl:text>:"</xsl:text>
		                            <xsl:value-of select="." />
		                            <xsl:text>"</xsl:text>
		                            <xsl:if test="position()!=last()">
		                            	<xsl:text>,</xsl:text>
		                            </xsl:if>
		                        </xsl:for-each>
		                        <xsl:if test="not(/RESPONSE/URL/language)">
		                            <xsl:text>,language:'</xsl:text>
		                            <xsl:value-of select="/RESPONSE/NECTIL/language"/>
		                            <xsl:text>'</xsl:text>
		                        </xsl:if>
							<xsl:text>});</xsl:text>
						</xsl:attribute>
					</a>
				</td>
				<td class="center">
					<table>
						<tr>
							<td align="center">
							<a class="tool query"  title="Display xSushee query" href="#">
								<xsl:attribute name="onclick">
									if ($(this).hasClass('tool-off')) return false;
									<xsl:text>$(AppController).panelslider('reloadPanel',</xsl:text>
									<xsl:value-of select="$panelID" />
									<xsl:text>, 0, {output:'query'});</xsl:text>
								</xsl:attribute>
							</a>
							</td>
							<td align="center">
							<a class="tool response"  title="Display XML response" href="#">
								<xsl:attribute name="onclick">
									if ($(this).hasClass('tool-off')) return false;
									<xsl:text>$(AppController).panelslider('reloadPanel',</xsl:text>
									<xsl:value-of select="$panelID" />
									<xsl:text>, 0, {output:'xml'});</xsl:text>
								</xsl:attribute>
							</a>
							</td>
							<td align="center">
							<a class="tool params"  title="Display URL parameters" href="#">
								<xsl:attribute name="onclick">
									if ($(this).hasClass('tool-off')) return false;
									<xsl:text>$(AppController).panelslider('reloadPanel',</xsl:text>
									<xsl:value-of select="$panelID" />
									<xsl:text>, 0, {output:'params'});</xsl:text>
								</xsl:attribute>
							</a>
							</td>
							<td align="center">
							<a class="tool xsl"  title="Display stylesheet" href="#">
								<xsl:attribute name="onclick">
									if ($(this).hasClass('tool-off')) return false;
									<xsl:text>$(AppController).panelslider('reloadPanel',</xsl:text>
									<xsl:value-of select="$panelID" />
									<xsl:text>, 0, {output:'xsl'});</xsl:text>
								</xsl:attribute>
							</a>
							</td>
							<td align="center">
							<a class="tool reload"  title="Reload this panel" href="#">
								<xsl:attribute name="onclick">
									if ($(this).hasClass('tool-off')) return false;
									<xsl:text>$(AppController).panelslider('reloadPanel',</xsl:text>
									<xsl:value-of select="$panelID" />
									<xsl:text>, 0, {output:''});</xsl:text>
								</xsl:attribute>
							</a>
							<xsl:if test="not(contains(/RESPONSE/URL/panelURI, 'system')) and 
											contains(/RESPONSE/URL/panelURI, 'Details') and 
											/RESPONSE/URL/module and /RESPONSE/URL/ID">
								<td align="center">
								<a class="tool rawedit"  title="Edit raw details ({/RESPONSE/URL/module} ID={/RESPONSE/URL/ID})" href="#">
									<xsl:attribute name="onclick">
										if ($(this).hasClass('tool-off')) return false;
									    <xsl:call-template name="navhandler">
									        <xsl:with-param name="title">
									        	<xsl:value-of select="translate(/RESPONSE/URL/module, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />
									        	<xsl:text> (</xsl:text>
									        	<xsl:value-of select="/RESPONSE/URL/ID" />
									        	<xsl:text>) - Raw edition</xsl:text>
									        </xsl:with-param>
											<xsl:with-param name="panelURI">
												<xsl:text>../../system/tools/element/Details</xsl:text>
											</xsl:with-param>
											<xsl:with-param name="params">
									            <xsl:text>module:'</xsl:text>
									            <xsl:value-of select="/RESPONSE/URL/module"/>
									            <xsl:text>',ID:</xsl:text>
									            <xsl:value-of select="/RESPONSE/URL/ID"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:attribute>
								</a>	
								</td>							
							</xsl:if>
							</td>
						</tr>
					</table>
				</td>
				<td class="right-toolbar">
					<a class="tool maximize"  title="Full screen" href="#">
						<xsl:attribute name="onclick">
							if ($(this).hasClass('tool-off')) return false;
							<xsl:text>$(AppController).panelslider('maximizePanel',</xsl:text>
							<xsl:value-of select="$panelID" />
							<xsl:text>);</xsl:text>
						</xsl:attribute>
					</a>
					<a class="tool normalsize"  title="Normal size" href="#">
						<xsl:attribute name="onclick">
							if ($(this).hasClass('tool-off')) return false;
							<xsl:text>$(AppController).panelslider('normalSizePanel',</xsl:text>
							<xsl:value-of select="$panelID" />
							<xsl:text>);</xsl:text>
						</xsl:attribute>
					</a>
				</td>
			</tr>
		</table>
	</xsl:template>

	<!--  title -->
	<xsl:template name="panel-title">
		<!--xsl:call-template name="truncate-phrase">
			<xsl:with-param name="phrase" select="/RESPONSE/URL/title"/>
		</xsl:call-template-->
		<xsl:value-of select="/RESPONSE/URL/title" />
	</xsl:template>
		
	<!--  header -->
	<xsl:template name="panel-header">
	</xsl:template>

	<!--  body loader -->
	<xsl:template name="panel-body-loader">
	    <div class="panel-body-loader">
	        <div class="flower"/>
	    </div>
	</xsl:template>
		
	<!--  body -->
	<xsl:template name="panel-body">
		<div class="block block-details">
			<xsl:call-template name="panel-block-details"/>
		</div>
		<div class="block-details-nav">
			<xsl:call-template name="panel-block-details-nav"/>
		</div>
		<div class="block block-nav">
			<xsl:call-template name="panel-block-nav"/>
		</div>
		<div class="block block-list">
			<xsl:call-template name="panel-block-list"/>
		</div>
	</xsl:template>
	
	<!-- details block (tabs) -->
	<xsl:template name="panel-block-details">
	</xsl:template>
	
	<!-- navigation details block (navigation items) -->
	<xsl:template name="panel-block-details-nav">
	</xsl:template>
	
	<!-- navigation block (navigation items) -->
	<xsl:template name="panel-block-nav">
	</xsl:template>
	
	<!-- list block (search results) -->
	<xsl:template name="panel-block-list">
	</xsl:template>
	
	<!-- javascripts -->
	<xsl:template name="panel-js">
		<xsl:param name="panelcssclass" />
		
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('<xsl:value-of select="$panelcssclass"/>');
	</xsl:template>
	
	<xsl:template name="panel-add-js">
	</xsl:template>
</xsl:stylesheet>