<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/List.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>	
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>

    <xsl:variable name="list" select="/RESPONSE/RESULTS[@name='list']"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
   	<xsl:template name="panel-body-navigation">
   		<xsl:choose>
	   		<xsl:when test="count($list/*) &gt; 0">
                <xsl:for-each select="$list/OFFICITY:REPORT">
                    <xsl:sort select="INFO/TITLE"/>
                    <xsl:apply-templates select="." mode="element-navitem" />
                </xsl:for-each>
                <xsl:choose>
                    <xsl:when test="/RESPONSE/URL/exportFormat='pdf'">
                        <xsl:call-template name="PDF-export-dialog" />
                    </xsl:when>
                    <xsl:when test="/RESPONSE/URL/exportFormat='csv'">
                        <xsl:call-template name="CSV-export-dialog" />
                    </xsl:when>
                </xsl:choose>
	   		</xsl:when>
	   		<xsl:otherwise>
				<div class="no-result">No reports configured</div>
	   		</xsl:otherwise>
   		</xsl:choose>
   	</xsl:template>
   	
   	<xsl:template name="panel-js-navigation">
	    <xsl:call-template name="js-init-datepicker">
	        <xsl:with-param name="selector" select="'#export-dialog #date'"/>
	    </xsl:call-template>
	    
        function displayPDFDialog(reportID, fixed, title, header, footer)
        {
            var today = getToday();
            $("#export-form #date").val(today.day + "/" + today.month + "/" + today.year);
            $("#export-form #title").val(title);
            $("#export-form #header").val(header);
            $("#export-form #footer").val(footer);
            $("#export-form #reportID").val(reportID);

            if (fixed == 1)
            {
                $("#export-form #use-display").hide();
            }
            exportDialog.show();

            return false;
        }

        function displayCSVDialog(reportID, fixed)
        {
            var today = getToday();
            $("#export-form #title").val("<xsl:value-of select="/RESPONSE/URL/moduleDesc"/> - " + today.year + today.month + today.day + "-" + today.hours + today.minutes);
            $("#export-form #reportID").val(reportID);

            if (fixed == 1)
            {
                $("#export-form #use-display").hide();
            }

            if (navigator.platform.toLowerCase().indexOf('mac') != -1)
            {
                $('#export-form #encoding').val('utf8');
                $('#export-form #separator').val('semicolon');
            }

            exportDialog.show();

            return false;
        }

        <!-- PROCESS -->
        var exportDialog = new ModalDialog(
            <xsl:value-of select="$panelID"/>,
            AppController,
            "#export-dialog",
            {
                bgiframe: true,
                width: 500,
                minHeight: 150,
                autoOpen: false,
            }
        );

        exportDialog.setCloseCallback(null);
        exportDialog.setCancelCallback('#cancel-button', null);

        exportDialog.setOkCallback("#ok-button", delegate(this, function(){
            fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);

            fm.onSuccess(function(response){
                var reportPath = response.message;
                var downloadURL = '<xsl:value-of select="$systemToolsURL"/>file_download.php?target='+reportPath;
                downloadURL += '<xsl:text disable-output-escaping='yes'>&amp;</xsl:text>rename='+escape(fm.getData('title'));
                window.location.replace(downloadURL);
            });

            exportDialog.hide();
            fm.displayProcess('Export in progress... Please wait.');
            fm.setScript('<xsl:value-of select="$systemToolsURL"/>report/make-report.php');
            fm.parse('#export-form');
            fm.addData('editor', '<xsl:value-of select="/RESPONSE/URL/editor"/>'); // to find the search configuration file
            fm.send();

            return false;
        }));
   	</xsl:template>
    
    <!-- save dialogs -->
    <xsl:template name="PDF-export-dialog">
        <div id="export-dialog" title="Export the results in PDF format" class="modal-dialog">
            <form id="export-form">
                <input id="exportFormat" name="exportFormat" type="hidden" value="{/RESPONSE/URL/exportFormat}"/>
                <input id="module" name="module" type="hidden" value="{/RESPONSE/URL/module}"/>
                <input id="reportID" name="reportID" type="hidden" value=""/>

                <div class="info">
                    <label>Title : </label>
                    <input id="title" name="title" type="text" class="input-text" value=""/>
                    <br/>
                    <label>Date : </label>
                    <input id="date" name="date" type="text" class="input-text"/>
                    <br/>
                    <label>Header : </label>
                    <input id="header" name="header" type="text" class="input-text"/>
                    <br/>
                    <label>Footer : </label>
                    <input id="footer" name="footer" type="text" class="input-text"/>
                    <br/>
                </div>
                <div class="info" id="use-display">
                    <label>Scale : </label>
                    <input id="fontSize" name="fontSize" type="text" value="100" maxlength="3" Size="3" class="input-text"/>
                    <xsl:text>%</xsl:text>
                    <br/>
                    <label>Format : </label>
                    <select id="format" name="format">
                        <option value="A4" selected="selected">A4</option>
                        <option value="A3">A3</option>
                    </select>
                    <br/>
                    <label>Orientation : </label>
                    <select id="orientation" name="orientation">
                        <option value="portrait" selected="selected">portrait</option>
                        <option value="landscape">landscape</option>
                    </select>
                    <br/><br/>
                    <label>&#160;</label>
                    <input id="useCurrentDisplay" name="useCurrentDisplay" type="checkbox" checked="checked" value="1"/>
                    <xsl:text>&#160;Use the current display configuration</xsl:text>
                </div>
                <div class="controls">
                    <a id="cancel-button" href="#">Cancel</a>&#160;&#160;or&#160;&#160;
                    <input id="ok-button" name="ok-button" type="button" value="Generate" class="modal-button"/>
                </div>
            </form>
        </div>
    </xsl:template>

    <xsl:template name="CSV-export-dialog">
        <div id="export-dialog" title="Export the results in CSV format" class="modal-dialog">
            <form id="export-form">
                <input id="exportFormat" name="exportFormat" type="hidden" value="{/RESPONSE/URL/exportFormat}"/>
                <input id="module" name="module" type="hidden" value="{/RESPONSE/URL/module}"/>
                <input id="reportID" name="reportID" type="hidden" value=""/>

                <div class="info">
                    <label>File name : </label>
                    <input id="title" name="title" type="text" class="input-text"/>
                </div>
                <div class="info">
                    <label>Encoding : </label>
                    <select id="encoding" name="encoding" class="input-small">
                        <option value="windows">Windows</option>
                        <option value="utf8">Mac/Linux</option>
                    </select>
                    <br />
                    <label>Separator : </label>
                    <select id="separator" name="separator" class="input-small">
                        <option value="comma">Comma (,)</option>
                        <option value="semicolon">Semicolon (;)</option>                        
                    </select>
                </div>
                <div class="info" id="use-display">
                    <label>&#160;</label>
                    <input id="useCurrentDisplay" name="useCurrentDisplay" type="checkbox" checked="checked" value="1"/>
                    <xsl:text>&#160;Use the current display configuration</xsl:text>
                </div>
                <div class="controls">
                    <a id="cancel-button" href="#">Cancel</a>&#160;&#160;or&#160;&#160;
                    <input id="ok-button" name="ok-button" type="button" value="Generate" class="modal-button"/>
                </div>
            </form>
        </div>
    </xsl:template>
</xsl:stylesheet>
