<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/report.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');

    /* *** */

	class ReportElement extends Element
	{
		private static $max_pagination = 2500;

		function __construct($ID=0)
		{
			parent::__construct('OFFICITY:REPORT', $ID);
		}

		function __destruct()
		{
			parent::__destruct();
		}

		/* *** */

        public function getStaticCommand($results_name='report-data')
		{
			$element_node = $this->getElementNode();

			$static_full_command = '
				<RESULTS name="'.$results_name.'" static="true">'.
					$element_node->toString('./*').
				'</RESULTS>';

			return $static_full_command;
		}

        public function getQueryString()
        {
            $query_xml_node = $this->getInfoNode('QUERYXML');
            if ($query_xml_node !== false)
            {
                return $query_xml_node->toString('./*');
            }

            return false;
        }

		public static function setMaxPagination($pagination)
		{
			self::$max_pagination = $pagination;
		}

		public static function getMaxPagination($pagination)
		{
			return self::$max_pagination;
		}
	}
?>