<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/search/functions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">

    <!-- CONFIG PARAMETERS : main search module, dependency modules involved, default fields, etc. -->
    <xsl:param name="search-config" select="/RESPONSE/RESULTS[@name='search-config']/CONFIGXML"/>
    <xsl:param name="search-module-denom" select="$search-config/MODULE"/>
    <xsl:param name="search-module-desc" select="$search-config/MODULEDESC"/>
    <xsl:param name="main-default-search-field-denom">
        <xsl:text>SEARCHTEXT</xsl:text>
    </xsl:param>

    <!-- SEARCH FILTER : new or loaded -->    
    <xsl:param name="search-filter" select="/RESPONSE/RESULTS[@name='search-filter']"/>
    <xsl:param name="filter-info" select="$search-filter/INFO"/>
    <xsl:param name="filter-display" select="$filter-info/DISPLAYXML"/>
    <xsl:param name="filter-query" select="$filter-info/QUERYXML"/>
    <xsl:param name="filter-query-element" select="$filter-query/*[1]"/>    
    <xsl:param name="filter-query-info" select="$filter-query-element/INFO"/>
    <xsl:param name="filter-query-deps" select="$filter-query-element/DEPENDENCIES/DEPENDENCY"/>
    <xsl:param name="filter-query-categs" select="$filter-query-element/CATEGORIES/CATEGORY"/>
    <xsl:param name="filter-query-distinct-categs" select="$filter-query-element/CATEGORIES/CATEGORY[not(@or_group=preceding-sibling::CATEGORY/@or_group)]"/>
    <!-- filterID exists in case of a loaded filter -->
    <xsl:param name="filterID" select="/RESPONSE/URL/filterID"/>

    <!-- DEFAULT SEARCH CRIT (ALWAYS DISPLAYED) -->
	<xsl:template name="default-search-crit">
        <xsl:param name="value"/>
        
		<div id="form-field-0" class="form-field form-item odd">
			<div class="default-search">Contains the words :</div>
			<input type="hidden" name="search-field-0" value="{/RESPONSE/URL/module}-info-{$main-default-search-field-denom}-text"/>
			<div id="search-operatorands-0" class="search-operatorands">
				<input type="hidden" name="search-operator-0" value="MATCH"/>
				<div id="search-operands-0" class="search-operands">
					<input id="search-operand1-0" class="search-operand1" type="text" value="{$value}" name="search-operand1-0"/>
				</div>
			</div>
			<a class="add icon" onclick="return $('#{$panelID}.panel').advancedsearcher('addCrit', null, '');" title="Add a criterion">
				<img src="{$systemImagesURL}icons/search/add.png"/>
			</a>
			<div class="clear"/>
		</div>
	</xsl:template>

    <!-- SEARCH TEMPLATES (HIDDEN) -->
	<xsl:template name="generate-all-templates">        
		<!-- main module : default info line template -->
		<div id="template-" class="form-field form-item" style="display:none;">
			<xsl:call-template name="build-info-line">
				<xsl:with-param name="moduleDenom" select="$search-module-denom"/>
				<xsl:with-param name="defaultFieldDenom" select="$search-config/DEFAULTFIELD"/>
				<xsl:with-param name="defaultOperator" select="$search-config/DEFAULTOPERATOR"/>
				<xsl:with-param name="defaultOperands" select="$search-config/DEFAULTOPERANDS"/>
			</xsl:call-template>
            <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
                <img src="{$systemImagesURL}icons/search/remove.png"/>
            </a>
            <div class="clear"/>
		</div>
		
		<!-- categories templates -->
		<div id="template-category-" class="form-item" style="display:none;"> 
			<xsl:call-template name="build-single-categ-line">
                  <xsl:with-param name="defaultOperator" select="'IS'"/>
                  <xsl:with-param name="categ" select="''"/>
                  <xsl:with-param name="lineID" select="''"/>
                  <xsl:with-param name="addButton" select="0"/>
                     <xsl:with-param name="containerID">
                         <xsl:text>template-category-</xsl:text>
                     </xsl:with-param>
			</xsl:call-template>
		</div>
		<div id="template-category-group-" class="form-field form-item category-fields-group" style="display:none;">
               <div class="frame">
                   <em>Corresponds to one of the following categories...</em>
				<div id="form-field-" class="form-item">
                       <xsl:call-template name="build-single-categ-line">
                           <xsl:with-param name="defaultOperator" select="'descendant'"/>
                           <xsl:with-param name="categ" select="''"/>
                           <xsl:with-param name="lineID" select="''"/>
                           <xsl:with-param name="addButton" select="1"/>
                              <xsl:with-param name="containerID">
                                  <xsl:text>template-category-group-</xsl:text>
                              </xsl:with-param>
                       </xsl:call-template>
				</div>
               </div>
               <!--a class="add-categ icon" title="Add a group of categories">
                   <img src="{$systemImagesURL}icons/search/add.png"/>
               </a-->
               <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this group of categories">
                   <img src="{$systemImagesURL}icons/search/remove.png"/>
               </a>
		</div>

        <!-- dependencies templates -->
        <xsl:for-each select="$search-config//DEPENDENCY">
            <xsl:sort select="@order" order="ascending"/>

            <!-- conversion for JavaScript ID usage -->
            <xsl:variable name="type-str">
                <xsl:call-template name="replace-string">
                    <xsl:with-param name="text"><xsl:value-of select="./TYPE"/></xsl:with-param>
                    <xsl:with-param name="from">:</xsl:with-param>
                    <xsl:with-param name="to">__</xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="lineContainerID">
                <xsl:text>template-</xsl:text>
                <xsl:value-of select="$type-str"/>
            </xsl:variable>

            <!-- default info line template for each dependency module -->
            <div id="{$lineContainerID}" class="form-item" style="display:none;">
                <xsl:call-template name="build-dep-info-line">
                    <xsl:with-param name="moduleDenom" select="./MODULE"/>
                    <xsl:with-param name="defaultFieldDenom" select="./DEFAULTFIELD"/>
                    <xsl:with-param name="defaultOperator" select="./DEFAULTOPERATOR"/>
                    <xsl:with-param name="defaultOperands" select="./DEFAULTOPERANDS"/>
                    <xsl:with-param name="dependencyType" select="./TYPE"/>
                </xsl:call-template>
                <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
                    <img src="{$systemImagesURL}icons/search/remove.png"/>
                </a>
                <div class="clear"/>
            </div>

            <!-- conversion for JavaScript ID usage -->
            <xsl:variable name="module-str">
                <xsl:call-template name="replace-string">
                    <xsl:with-param name="text"><xsl:value-of select="./MODULE"/></xsl:with-param>
                    <xsl:with-param name="from">:</xsl:with-param>
                    <xsl:with-param name="to">__</xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="groupContainerID">
                <xsl:text>template-dependency-</xsl:text>
                <xsl:value-of select="$type-str"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="$module-str"/>
            </xsl:variable>

            <!-- group template for each dependency module... -->
            <div id="{$groupContainerID}" class="form-field form-item dependency-fields-group" style="display:none;">
                <div class="frame">
                    <em><xsl:value-of select="./DESC"/></em>
                    <!-- initialized with its default info line template -->
                    <div id="form-field-" class="form-item">
                        <xsl:call-template name="build-dep-info-line">
                            <xsl:with-param name="moduleDenom" select="./MODULE"/>
                            <xsl:with-param name="defaultFieldDenom" select="./DEFAULTFIELD"/>
                            <xsl:with-param name="defaultOperator" select="./DEFAULTOPERATOR"/>
                            <xsl:with-param name="defaultOperands" select="./DEFAULTOPERANDS"/>
                            <xsl:with-param name="dependencyType" select="./TYPE"/>
                        </xsl:call-template>
                        <a class="add icon" onclick="return $('#{$panelID}.panel').advancedsearcher('addCrit', this, '{./TYPE}');" title="Add a criterion to this group">
                            <img src="{$systemImagesURL}icons/search/add.png"/>
                        </a>
                        <div class="clear"/>
                    </div>
                </div>
                <a class="remove icon" title="Remove this group">
                    <xsl:attribute name="onclick">
                        <xsl:for-each select="./DEPENDENCIES/DEPENDENCY">
                        	$('#<xsl:value-of select="$panelID" />.panel').advancedsearcher('restoreDependencySearchOption', '<xsl:value-of select="./TYPE"/>', '<xsl:value-of select="./MODULE"/>');
                        </xsl:for-each>
                        $('#<xsl:value-of select="$panelID" />.panel').advancedsearcher('removeDependencySearch', this, '<xsl:value-of select="./TYPE"/>', '<xsl:value-of select="./MODULE"/>');
                        return false;
                    </xsl:attribute>
                    <img src="{$systemImagesURL}icons/search/remove.png"/>
                </a>
            </div>
        </xsl:for-each>
	</xsl:template>

    <!-- MAIN MODULE : INFO LINE TEMPLATE -->
	<xsl:template name="build-info-line">
        <xsl:param name="lineID" select="''"/>
		<xsl:param name="moduleDenom"/>
		<xsl:param name="defaultFieldDenom"/>
		<xsl:param name="defaultOperator"/>
        <xsl:param name="defaultOperands"/>

        <xsl:variable name="defaultField" select="//FIELD[INFO/MODULE=$moduleDenom and INFO/DENOMINATION=$defaultFieldDenom]"/>

        <!-- special operators -->
		<xsl:variable name="defaultOperator">
            <xsl:choose>
                <xsl:when test="$defaultOperands='0000-00-00 00:00:00' or $defaultOperands='0000-00-00'">
                    <xsl:value-of select="'notdefined'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='this_year'">
                    <xsl:value-of select="'thisyear'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='this_month'">
                    <xsl:value-of select="'thismonth'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='this_week'">
                    <xsl:value-of select="'thisweek'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='today'">
                    <xsl:value-of select="'today'"/>
                </xsl:when>
                <xsl:when test="contains($defaultOperands, 'today-')">
                    <xsl:value-of select="'since'"/>
                </xsl:when>
                <xsl:when test="contains($defaultOperands, 'today+')">
                    <xsl:value-of select="'forthenext'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$defaultOperator"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

		<xsl:call-template name="field-names">
            <xsl:with-param name="lineID" select="$lineID"/>
			<xsl:with-param name="moduleDenom" select="$moduleDenom"/>
			<xsl:with-param name="selectedFieldDenom" select="$defaultFieldDenom"/>
		</xsl:call-template>

		<div id="search-operatorands-{$lineID}" class="search-operatorands">
			<xsl:call-template name="operator">
				<xsl:with-param name="lineID" select="$lineID"/>
				<xsl:with-param name="fieldType" select="$defaultField/INFO/TYPE"/>
		        <xsl:with-param name="selectedOperator" select="$defaultOperator"/>
			</xsl:call-template>
			<div id="search-operands-{$lineID}" class="search-operands">
				<xsl:call-template name="operands">
					<xsl:with-param name="lineID" select="$lineID"/>
					<xsl:with-param name="list" select="/RESPONSE/RESULTS/descendant-or-self::*[@name=$defaultField/INFO/LISTNAME]"/>
					<xsl:with-param name="fieldType" select="$defaultField/INFO/TYPE"/>
					<xsl:with-param name="selectedOperator" select="$defaultOperator"/>
			        <xsl:with-param name="operands" select="$defaultOperands"/>                    
				</xsl:call-template>
			</div>
		</div>
	</xsl:template>

    <!-- DEPENDENCY MODULES : INFO LINE TEMPLATE -->
	<xsl:template name="build-dep-info-line">
        <xsl:param name="lineID" select="''"/>
		<xsl:param name="moduleDenom"/>
		<xsl:param name="defaultFieldDenom"/>
		<xsl:param name="defaultOperator"/>
        <xsl:param name="defaultOperands"/>
        <xsl:param name="dependencyType" select="''"/>

        <xsl:variable name="defaultField" select="//FIELD[INFO/MODULE=$moduleDenom and INFO/DENOMINATION=$defaultFieldDenom]"/>

        <!-- special operators -->
		<xsl:variable name="defaultOperator">
            <xsl:choose>
                <xsl:when test="$defaultOperands='0000-00-00 00:00:00' or $defaultOperands='0000-00-00'">
                    <xsl:value-of select="'notdefined'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='this_year'">
                    <xsl:value-of select="'thisyear'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='this_month'">
                    <xsl:value-of select="'thismonth'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='this_week'">
                    <xsl:value-of select="'thisweek'"/>
                </xsl:when>
                <xsl:when test="$defaultOperands='today'">
                    <xsl:value-of select="'today'"/>
                </xsl:when>
                <xsl:when test="contains($defaultOperands, 'today-')">
                    <xsl:value-of select="'since'"/>
                </xsl:when>
                <xsl:when test="contains($defaultOperands, 'today+')">
                    <xsl:value-of select="'forthenext'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$defaultOperator"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

		<xsl:call-template name="dep-field-names">
            <xsl:with-param name="lineID" select="$lineID"/>
			<xsl:with-param name="moduleDenom" select="$moduleDenom"/>
			<xsl:with-param name="selectedFieldDenom" select="$defaultFieldDenom"/>
            <xsl:with-param name="dependencyType" select="$dependencyType"/>
		</xsl:call-template>
		
        <xsl:variable name="fieldType">
            <xsl:choose>
                <!-- dependencies count criterion -->
                <xsl:when test="$defaultFieldDenom='dephits'">
                	<xsl:text>dephits</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$defaultField/INFO/TYPE"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

		<div id="search-operatorands-{$lineID}" class="search-operatorands">
			<xsl:call-template name="operator">
				<xsl:with-param name="lineID" select="$lineID"/>
				<xsl:with-param name="fieldType"  select="$fieldType" />
		        <xsl:with-param name="selectedOperator" select="$defaultOperator"/>
			</xsl:call-template>

			<div id="search-operands-{$lineID}" class="search-operands">
				<xsl:call-template name="operands">
					<xsl:with-param name="lineID" select="$lineID"/>
                    <xsl:with-param name="fieldType" select="$fieldType"/>
					<xsl:with-param name="list" select="/RESPONSE/RESULTS/descendant-or-self::*[@name=$defaultField/INFO/LISTNAME]"/>
					<xsl:with-param name="elemsListFieldDenom" select="$defaultFieldDenom"/>
					<xsl:with-param name="selectedOperator" select="$defaultOperator"/>
			        <xsl:with-param name="operands" select="$defaultOperands"/>                    
				</xsl:call-template>
			</div>
		</div>
	</xsl:template>
   
    <!-- MAIN MODULE : FIELDS NAMES SELECT + DEPENDENCIES OPTIONS -->
    <xsl:template name="field-names">
        <xsl:param name="lineID"/>
        <xsl:param name="moduleDenom"/>
        <xsl:param name="selectedFieldDenom"/>

        <select id="search-field-{$lineID}" name="search-field-{$lineID}" class="search-field">
            <xsl:if test="$lineID!=''">
                <xsl:attribute name="onchange">$('#<xsl:value-of select="$panelID" />.panel').advancedsearcher('selectOperatorands', '<xsl:value-of select="$lineID"/>');</xsl:attribute>
            </xsl:if>

            <!-- INFOS FIELDS OPTIONS -->
            <optgroup label="INFOS FIELDS">
                <xsl:for-each select="//FIELD[INFO/MODULE=$moduleDenom]">
                    <xsl:sort select="translate(DESCRIPTIONS/DESCRIPTION/TITLE, $xsltsl-str-upper, $xsltsl-str-lower)" order="ascending"/>
                    <xsl:sort select="INFO/DENOMINATION" order="ascending"/>
                    <option>
                        <xsl:if test="INFO/DENOMINATION = $selectedFieldDenom">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="value">
                            <xsl:value-of select="$moduleDenom"/>
                            <xsl:text>-info-</xsl:text>
                            <xsl:value-of select="INFO/DENOMINATION"/>
                            <xsl:text>-</xsl:text>
                            <!-- additional data for load-search-info.php -->
                            <xsl:value-of select="INFO/TYPE"/>
                            <xsl:choose>
	                            <xsl:when test="INFO/TYPE='list' or INFO/TYPE='systemList'">
	                                <xsl:text>_</xsl:text> 
	                                <xsl:value-of select="INFO/LISTNAME"/>
	                            </xsl:when>
	                            <xsl:otherwise></xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="DESCRIPTIONS/DESCRIPTION/TITLE/text()">
                                <xsl:value-of select="DESCRIPTIONS/DESCRIPTION/TITLE"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="INFO/DENOMINATION"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </option>
                </xsl:for-each>
            </optgroup>

            <!-- DEPENDENCIES OBJECTS OPTIONS -->
            <xsl:call-template name="deps-search-options">
                <xsl:with-param name="deps-config" select="$search-config"/>
            </xsl:call-template>
            
            <xsl:if test="($moduleDenom=$search-module-denom) and $search-config/CATEGORIES">
	            <optgroup label="CATEGORIES">
		            <!--option value="optgroup-category">
		            	<xsl:text>Corresponds to...</xsl:text>
		            </option-->
		            <xsl:for-each select="$search-config/CATEGORIES/CATEGORY">
		            	<option>
		            		<xsl:attribute name="value">
		            			<xsl:text>optgroup-category-</xsl:text>
			            		<xsl:value-of select="@name" />
		            		</xsl:attribute>
		            		<xsl:text>Belongs to </xsl:text>
		            		<xsl:value-of select="@label" />
		            		<xsl:text>...</xsl:text>
		            	</option>
		            </xsl:for-each>
	            </optgroup>
            </xsl:if>
        </select>
    </xsl:template>

    <!-- DEPENDENCY MODULES : FIELDS NAMES SELECT + DEPENDENCIES OPTIONS -->
    <xsl:template name="dep-field-names">
        <xsl:param name="lineID"/>
        <xsl:param name="moduleDenom"/>
        <xsl:param name="selectedFieldDenom"/>
        <xsl:param name="dependencyType" select="''"/>

        <select id="search-field-{$lineID}" name="search-field-{$lineID}" class="search-field">
            <xsl:if test="$lineID!=''">
                <xsl:attribute name="onchange">$('#<xsl:value-of select="$panelID" />.panel').advancedsearcher('selectOperatorands', '<xsl:value-of select="$lineID"/>');</xsl:attribute>
            </xsl:if>

            <optgroup label="CARDINALITY">
                <option value="dependency-{$dependencyType}-{$moduleDenom}-dephits">
                    <xsl:if test="$selectedFieldDenom='dephits'">
                        <xsl:attribute name="selected">selected</xsl:attribute>
                    </xsl:if>
                    <xsl:text>Dependencies count</xsl:text>
                </option>
            </optgroup>

            <!-- INFOS FIELDS OPTIONS -->
            <optgroup label="INFOS FIELDS">
                <xsl:for-each select="//FIELD[INFO/MODULE=$moduleDenom]">
                    <xsl:sort select="translate(DESCRIPTIONS/DESCRIPTION/TITLE, $xsltsl-str-upper, $xsltsl-str-lower)" order="ascending"/>
                    <xsl:sort select="INFO/DENOMINATION" order="ascending"/>

                    <option>
                        <xsl:if test="INFO/DENOMINATION = $selectedFieldDenom">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:attribute name="value">
                            <xsl:choose>
                                <!-- the elementsList type is used to directly identify an object in dependency... -->
                                <xsl:when test="INFO/TYPE='elementsList'">
                                    <xsl:text>dependency-</xsl:text>
                                    <xsl:value-of select="$dependencyType"/>
                                    <xsl:text>-</xsl:text>
                                    <xsl:value-of select="$moduleDenom"/>
                                    <xsl:text>-info-</xsl:text>
                                    <!-- ...so we use the ID to identify the object in dependency -->
                                    <xsl:text>ID</xsl:text>
                                    <xsl:text>-</xsl:text>
                                    <!-- additional data for load-search-info.php -->
                                    <xsl:text>elementsList</xsl:text>
                                    <xsl:text>_</xsl:text>
                                    <!-- module used to build the list -->
                                    <xsl:value-of select="INFO/TARGETMODULE"/>
                                    <xsl:text>_</xsl:text>
                                    <!-- field to display in the list -->
                                    <xsl:value-of select="INFO/TARGETFIELD"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>dependency-</xsl:text>
                                    <xsl:value-of select="$dependencyType"/>
                                    <xsl:text>-</xsl:text>
                                    <xsl:value-of select="$moduleDenom"/>
                                    <xsl:text>-info-</xsl:text>
                                    <xsl:value-of select="INFO/DENOMINATION"/>
                                    <xsl:text>-</xsl:text>
                                    <!-- additional data for load-search-info.php -->
                                    <xsl:value-of select="INFO/TYPE"/>
                                    <xsl:if test="INFO/TYPE='list' or INFO/TYPE='systemList'">
                                        <xsl:text>_</xsl:text>
                                        <xsl:value-of select="INFO/LISTNAME"/>
                                    </xsl:if>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                        <xsl:choose>
                            <xsl:when test="DESCRIPTIONS/DESCRIPTION/TITLE/text()">
                                <xsl:value-of select="DESCRIPTIONS/DESCRIPTION/TITLE"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="INFO/DENOMINATION"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </option>
                </xsl:for-each>
            </optgroup>

            <!-- DEPENDENCIES OBJECTS OPTIONS -->
            <xsl:call-template name="deps-search-options">
                <xsl:with-param name="deps-config" select="$search-config/DEPENDENCIES/DEPENDENCY[MODULE=$moduleDenom and TYPE=$dependencyType]"/>
            </xsl:call-template>
        </select>
    </xsl:template>

    <xsl:template name="deps-search-options">
        <xsl:param name="deps-config" />

        <xsl:if test="count($deps-config/DEPENDENCIES/DEPENDENCY) > 0">
            <optgroup label="DEPENDENCIES">
                <xsl:for-each select="$deps-config/DEPENDENCIES/DEPENDENCY">
                    <xsl:sort select="./@order" order="ascending" data-type="number"/>

                        <option value="optgroup-dependency-{./TYPE}-{./MODULE}">
                            <!-- loaded filter? -->
                            <xsl:if test="$filterID">
                                <xsl:attribute name="style">
                                    <xsl:choose>
                                        <xsl:when test="$filter-query-deps[@type=current()/TYPE]">
                                            <xsl:text>display:none;</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>display:block;</xsl:text>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="./DESC"/>
                        </option>
                </xsl:for-each>
            </optgroup>
        </xsl:if>
    </xsl:template>
    
    <!-- SINGLE CATEG LINE -->
	<xsl:template name="build-single-categ-line">
		<xsl:param name="targetCategName" />
        <xsl:param name="lineID"/>
		<xsl:param name="defaultOperator"/>
        <xsl:param name="defaultCateg"/>
        <xsl:param name="addButton"/>
        <xsl:param name="containerID"/>
        
		<div id="search-operatorands-{$lineID}" class="search-operatorands">
	        <xsl:if test="$addButton='0'">
	        	<div class="or">or</div>
	        </xsl:if>        
			<xsl:call-template name="categ-operator">
				<xsl:with-param name="lineID" select="$lineID"/>
		        <xsl:with-param name="selectedOperator" select="$defaultOperator"/>
			</xsl:call-template>
			<div id="search-operands-{$lineID}" class="search-operands">
				<xsl:call-template name="build-categ-operand">
					<xsl:with-param name="targetCategName" select="$targetCategName" />
					<xsl:with-param name="lineID" select="$lineID"/>
			        <xsl:with-param name="selectedCateg" select="$defaultCateg"/>
                    <xsl:with-param name="containerID" select="$containerID"/>
				</xsl:call-template>
			</div>
		</div>

		<xsl:choose>
			<xsl:when test="$addButton=1">
				<a class="add icon" onclick="return $('#{$panelID}.panel').advancedsearcher('addCategoryCrit', this, '{$targetCategName}');" title="Add a criterion to this group">
					<img src="{$systemImagesURL}icons/search/add.png"/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
					<img src="{$systemImagesURL}icons/search/remove.png"/>
				</a>
			</xsl:otherwise>
		</xsl:choose>
		<div class="clear"/>
	</xsl:template>
	
    <!-- CATEGS -->
    <xsl:template name="categ-operator">
        <xsl:param name="lineID"/>
        <xsl:param name="selectedOperator"/>
        <select id="search-operator-{$lineID}" name="search-operator-{$lineID}" class="search-operator">
            <option value="descendant">
                <xsl:if test="$selectedOperator='descendant'">
                    <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
        		<xsl:text>Belongs to</xsl:text>
        	</option>
        	<option value="IS">
                <xsl:if test="$selectedOperator='IS'">
                    <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
	        	<xsl:text>Is</xsl:text>
        	</option>
        	<option value="not">
                <xsl:if test="$selectedOperator='not'">
                    <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
        		<xsl:text>Is not</xsl:text>
        	</option>
		</select>
    </xsl:template>
    
	<xsl:template name="build-categ-operand">
        <xsl:param name="targetCategName" />
		<xsl:param name="lineID" />
        <xsl:param name="selectedCateg" />
        <xsl:param name="containerID" />
        
        <xsl:variable name="rootCateg" select="/RESPONSE/RESULTS//CATEGORY[UNIQUENAME=$targetCategName]"/>

		<select id="search-categ-{$lineID}" name="search-categ-{$lineID}"  class="search-categ">
			<option value="{$rootCateg/UNIQUENAME}" style="font-weight:bold; font-variant:small-caps;">
	            <xsl:if test="$selectedCateg=$rootCateg/UNIQUENAME">
	                <xsl:attribute name="selected">selected</xsl:attribute>
                </xsl:if>
				<xsl:value-of select="$rootCateg/LABEL"/>
			</option>
			<xsl:for-each select="$rootCateg/CATEGORY">
				<xsl:sort select="LABEL" />	
                <xsl:call-template name="build-categ-list-rec">
                	<xsl:with-param name="currentCateg" select="."/>
                	<xsl:with-param name="selectedCateg" select="$selectedCateg" />
                </xsl:call-template>
			</xsl:for-each>			
		</select>
		<input type="hidden" id="search-group-{$lineID}" name="search-group-{$lineID}" class="search-group" value="{$containerID}"/>
	</xsl:template>
	
	<xsl:template name="build-categ-list-rec">
        <xsl:param name="currentCateg"/>
        <xsl:param name="selectedCateg" />
        <xsl:param name="currentMargin" select="8"/> 
        
        <xsl:choose>
	       	<xsl:when test="$currentCateg/CATEGORY">
				<option value="{$currentCateg/UNIQUENAME}" style="font-weight:bold; font-variant:small-caps; margin-left:{$currentMargin}px;">
                    <xsl:if test="$selectedCateg=$currentCateg/UNIQUENAME">
                        <xsl:attribute name="selected">selected</xsl:attribute>
                    </xsl:if>
					<xsl:value-of select="$currentCateg/LABEL"/>
					<!--xsl:text> (</xsl:text>
					<xsl:value-of select="$currentCateg/@totalElements"/>
					<xsl:text>)</xsl:text-->
				</option>
				<xsl:for-each select="$currentCateg/CATEGORY">
					<xsl:sort select="count(./CATEGORY)=0" order="descending"/>	
					<xsl:sort select="LABEL" />
					<xsl:call-template name="build-categ-list-rec">
						<xsl:with-param name="currentCateg" select="."/>
						<xsl:with-param name="selectedCateg" select="$selectedCateg" />
						<xsl:with-param name="currentMargin" select="$currentMargin+8"/>
					</xsl:call-template>
				</xsl:for-each>
	       	</xsl:when>
	       	<xsl:otherwise>			
				<option value="{$currentCateg/UNIQUENAME}">
					<xsl:attribute name="style">
						<xsl:text>margin-left:</xsl:text>
						<xsl:value-of select="$currentMargin" />
						<xsl:text>px;</xsl:text>
						<xsl:if test="parent::RESULTS">
							<xsl:text>font-weight:bold; font-variant:small-caps;</xsl:text>
						</xsl:if>
					</xsl:attribute>
                    <xsl:if test="$selectedCateg=$currentCateg/UNIQUENAME">
                        <xsl:attribute name="selected">selected</xsl:attribute>
                    </xsl:if>
					<xsl:value-of select="$currentCateg/LABEL"/>
					<!--xsl:text> (</xsl:text>
					<xsl:value-of select="$currentCateg/@totalElements"/>
					<xsl:text>)</xsl:text-->
				</option>
	       	</xsl:otherwise>
       </xsl:choose>
	</xsl:template>
	
      <!-- ALL CRIT LINES FOR A CATEGORIES NODE-->
	<xsl:template name="build-categs-criteria">
        <xsl:param name="id"/>
        <xsl:param name="groupName" />
        <xsl:param name="currentNode"/>
        <xsl:param name="addButton"/>
        <xsl:param name="containerID"/>
        
        <xsl:if test="$currentNode">
            <xsl:variable name="bkgndClass">
                <xsl:choose>
                    <xsl:when test="($id mod 2) = 0">
                        <xsl:text>form-field odd</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>form-field even</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
			
            <div id="form-field-{$id}" class="form-item {$bkgndClass}">
                <xsl:call-template name="build-single-categ-line">
                    <xsl:with-param name="targetCategName" select="/RESPONSE/RESULTS//CATEGORY[UNIQUENAME=$currentNode/@name]/UNIQUENAME"/>
                    <xsl:with-param name="lineID" select="$id"/>
                    <xsl:with-param name="defaultOperator" select="$currentNode/@operator"/>                    
                    <xsl:with-param name="defaultCateg" select="$currentNode/@name"/>
                    <xsl:with-param name="addButton" select="$addButton"/>
                    <xsl:with-param name="containerID" select="$containerID"/>
                </xsl:call-template>
            </div>

            <xsl:call-template name="build-categs-criteria">
                <xsl:with-param name="id" select="$id+1"/>
                <xsl:with-param name="groupName" select="$groupName" />
                <xsl:with-param name="currentNode" select="$currentNode/following-sibling::*[@or_group=$groupName][1]"/>
                <xsl:with-param name="addButton" select="0"/>
                <xsl:with-param name="containerID" select="$containerID"/>
            </xsl:call-template>
        </xsl:if>
	</xsl:template>

    <!-- LOADED FILTER RECONSTRUCTION : INFO LINE TEMPLATE -->
    <xsl:template name="rebuild-info-lines">
        <xsl:param name="currentNode" />
        <xsl:param name="lineID" select="1"/>

        <!-- recursion complete? -->
        <xsl:if test="$currentNode">
            <xsl:variable name="bkgndClass">
                <xsl:choose>
                    <xsl:when test="($lineID mod 2) = 0">
                        <xsl:text>odd</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>even</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:variable name="containerID" select="concat('form-field-', $lineID)"/>

            <div id="{$containerID}" class="form-field form-item {$bkgndClass}">
                <xsl:call-template name="build-info-line">
                    <xsl:with-param name="lineID" select="$lineID"/>
                    <xsl:with-param name="moduleDenom" select="$search-module-denom"/>
                    <xsl:with-param name="defaultFieldDenom" select="name($currentNode)"/>
                    <xsl:with-param name="defaultOperator" select="$currentNode/@operator"/>
                    <xsl:with-param name="defaultOperands" select="$currentNode/text()"/>
                </xsl:call-template>
                <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
                    <img src="{$systemImagesURL}icons/search/remove.png"/>
                </a>
                <div class="clear"/>
            </div>

            <!-- recursion call -->
            <xsl:call-template name="rebuild-info-lines">
                <xsl:with-param name="currentNode" select="$currentNode/following-sibling::*[1]"/>
                <xsl:with-param name="lineID" select="$lineID+1"/>
            </xsl:call-template>
        </xsl:if>
	</xsl:template>
	
    <!-- LOADED FILTER RECONSTRUCTION : CATEGORY LINE TEMPLATE -->
    <xsl:template name="rebuild-categ-lines">
        <xsl:param name="currentNode" />
        <xsl:param name="lineID" select="1"/>
    </xsl:template>
    
    <!-- LOADED FILTER RECONSTRUCTION : DEP HITS COUNT LINE TEMPLATE -->
    <xsl:template name="rebuild-dep-hits-line">
    	<xsl:param name="moduleDenom" />
    	<xsl:param name="depNode" />
    	<xsl:param name="lineID" />
    	<xsl:param name="addButton" select="1" />
    	
        <xsl:variable name="containerID" select="concat('form-field-', $lineID)"/>
        <xsl:variable name="bkgndClass">
            <xsl:choose>
                <xsl:when test="($lineID mod 2) = 0">
                    <xsl:text>odd</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>even</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <div id="{$containerID}" class="form-field form-item {$bkgndClass}">
            <xsl:call-template name="build-dep-info-line">
                <xsl:with-param name="lineID" select="$lineID"/>
                <xsl:with-param name="moduleDenom" select="$moduleDenom"/>
                <xsl:with-param name="defaultFieldDenom" select="'dephits'"/>
                <xsl:with-param name="defaultOperator">
                	<xsl:choose>
                		<xsl:when test="$depNode/@operator">
                			<xsl:value-of select="$depNode/@operator" />
                		</xsl:when>
                		<xsl:when test="$depNode/*[1]/HITS/@operator">
                			<xsl:value-of select="$depNode/*[1]/HITS/@operator" />
                		</xsl:when>
                	</xsl:choose>
                </xsl:with-param>
                <xsl:with-param name="defaultOperands">
                	<xsl:choose>
                		<xsl:when test="$depNode/@operator">
                			<xsl:value-of select="$depNode/@operator" />
                		</xsl:when>
                		<xsl:when test="$depNode/*[1]/HITS/@operator">
                			<xsl:value-of select="$depNode/*[1]/HITS" />
                		</xsl:when>
                	</xsl:choose>
                </xsl:with-param>
                <xsl:with-param name="dependencyType" select="$depNode/@type"/>
            </xsl:call-template>
            
            <xsl:choose>
                <xsl:when test="$addButton = 1">
                    <a class="add icon" onclick="return $('#{$panelID}.panel').advancedsearcher('addCrit', this, '{$depNode/@type}');" title="Add a criterion to this group">
                        <img src="{$systemImagesURL}icons/search/add.png"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
                        <img src="{$systemImagesURL}icons/search/remove.png"/>
                    </a>                
                </xsl:otherwise>                    
            </xsl:choose>
            <div class="clear"/>
        </div>
    </xsl:template>

    <!-- LOADED FILTER RECONSTRUCTION  : DEPENDENCY MODULES INFO LINE TEMPLATE -->
    <xsl:template name="rebuild-dep-info-lines">
        <xsl:param name="moduleDenom" />
        <xsl:param name="currentNode" />
        <xsl:param name="lineID" />
        <xsl:param name="dependencyType" />
        <xsl:param name="dependencyOperator" />
        <xsl:param name="addButton" select="1" />

        <!-- recursion complete? -->
        <xsl:if test="$currentNode">
            <xsl:variable name="bkgndClass">
                <xsl:choose>
                    <xsl:when test="($lineID mod 2) = 0">
                        <xsl:text>odd</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>even</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <!-- when choosing an item in a elementsList, we save the ID value of the dependency object -->
            <!-- (the elementsList type is used to directly identify an object in dependency) -->
            <!-- in this case, we replace the ID field by the TARGETFIELD field -->
            <xsl:variable name="nodeName">
                <xsl:choose>
                    <xsl:when test="name($currentNode)='ID'">
                        <xsl:value-of select="//FIELD[(INFO/TYPE='elementsList') and (INFO/MODULE=$search-module-denom) and (INFO/TARGETMODULE=$moduleDenom)]/INFO/TARGETFIELD"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="name($currentNode)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:variable name="containerID" select="concat('form-field-', $lineID)"/>

            <div id="{$containerID}" class="form-field form-item {$bkgndClass}">
                <xsl:call-template name="build-dep-info-line">
                    <xsl:with-param name="lineID" select="$lineID"/>
                    <xsl:with-param name="moduleDenom" select="$moduleDenom"/>
                    <xsl:with-param name="defaultFieldDenom" select="$nodeName"/>
                    <xsl:with-param name="defaultOperator" select="$currentNode/@operator"/>
                    <xsl:with-param name="defaultOperands" select="$currentNode/text()"/>
                    <xsl:with-param name="dependencyType" select="$dependencyType"/>
                </xsl:call-template>
                
                <xsl:choose>
                    <xsl:when test="$addButton = 1">
                        <a class="add icon" onclick="return $('#{$panelID}.panel').advancedsearcher('addCrit', this, '{$dependencyType}');" title="Add a criterion to this group">
                            <img src="{$systemImagesURL}icons/search/add.png"/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a class="remove icon" onclick="return $('#{$panelID}.panel').advancedsearcher('removeCrit', this);" title="Remove this criterion">
                            <img src="{$systemImagesURL}icons/search/remove.png"/>
                        </a>                
                    </xsl:otherwise>                    
                </xsl:choose>
                <div class="clear"/>
            </div>

            <!-- recursion call -->
            <xsl:call-template name="rebuild-dep-info-lines">
                <xsl:with-param name="moduleDenom" select="$moduleDenom" />
                <xsl:with-param name="currentNode" select="$currentNode/following-sibling::*[1]"/>
                <xsl:with-param name="lineID" select="$lineID+1"/>
                <xsl:with-param name="dependencyType" select="$dependencyType" />
                <!-- if more than one, display a 'remove' button instead of an 'add' button -->
                <xsl:with-param name="addButton" select="0" />
            </xsl:call-template>
        </xsl:if>
	</xsl:template>

    <!-- OPERATORS -->
    <xsl:template name="operator">
        <xsl:param name="lineID"/>
        <xsl:param name="fieldType"/>
        <xsl:param name="selectedOperator"/>

        <select id="search-operator-{$lineID}" name="search-operator-{$lineID}" class="search-operator">
            <xsl:if test="$lineID!=''">
                <xsl:attribute name="onchange">$('#<xsl:value-of select="$panelID" />.panel').advancedsearcher('selectOperands', '<xsl:value-of select="$lineID"/>');</xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$fieldType='searchtext'">
                    <option value="MATCH">
                        <xsl:if test="$selectedOperator='MATCH'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>contains</xsl:text>
                    </option>
                    <option value="like">
                        <xsl:if test="$selectedOperator='like'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>like</xsl:text>
                    </option>
                </xsl:when>
                <xsl:when test="$fieldType='fetch'">
                    <option value="contains">
                        <xsl:if test="$selectedOperator='contains'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>contains</xsl:text>
                    </option>
                </xsl:when>
                <xsl:when test="($fieldType='int') or ($fieldType='float') or ($fieldType='decimal')">
                    <option value="=">
                        <xsl:if test="$selectedOperator='='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is equal to</xsl:text>
                    </option>
                    <option value="NE">
                        <xsl:if test="$selectedOperator='NE'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is not equal to</xsl:text>
                    </option>
                    <option value="GT">
                        <xsl:if test="$selectedOperator='GT'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is greater than</xsl:text>
                    </option>
                    <option value="GT=">
                        <xsl:if test="$selectedOperator='GT='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is greater or equal to</xsl:text>
                    </option>
                    <option value="LT">
                        <xsl:if test="$selectedOperator='LT'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is lower than</xsl:text>
                    </option>
                    <option value="LT=">
                        <xsl:if test="$selectedOperator='LT='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is lower or equal to</xsl:text>
                    </option>
                    <option value="between">
                        <xsl:if test="$selectedOperator='between'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is between</xsl:text>
                    </option>
                    <option value="IN">
                        <xsl:if test="$selectedOperator='IN'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>are equal to</xsl:text>
                    </option>
                    <option value="NOT IN">
                        <xsl:if test="$selectedOperator='NOT IN'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>are not equal to</xsl:text>
                    </option>
                </xsl:when>
                <xsl:when test="($fieldType='date') or ($fieldType='datetime')">
                    <option value="=">
                        <xsl:if test="$selectedOperator='='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is</xsl:text>
                    </option>
                    <option value="LT">
                        <xsl:if test="$selectedOperator='LT'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is earlier than</xsl:text>
                    </option>
                    <option value="GT">
                        <xsl:if test="$selectedOperator='GT'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is later than</xsl:text>
                    </option>
                    <option value="between">
                        <xsl:if test="$selectedOperator='between'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is between</xsl:text>
                    </option>
                    <option value="today">
                        <xsl:if test="$selectedOperator='today'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is today</xsl:text>
                    </option>
                    <option value="thisweek">
                        <xsl:if test="$selectedOperator='thisweek'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is in this week</xsl:text>
                    </option>
                    <option value="thismonth">
                        <xsl:if test="$selectedOperator='thismonth'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is in this month</xsl:text>
                    </option>
                    <option value="thisyear">
                        <xsl:if test="$selectedOperator='thisyear'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is in this year</xsl:text>
                    </option>
                    <option value="since">
                        <xsl:if test="$selectedOperator='since'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>since</xsl:text>
                    </option>
                    <option value="forthenext">
                        <xsl:if test="$selectedOperator='forthenext'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>for the next</xsl:text>
                    </option>
                    <option value="notdefined">
                        <xsl:if test="$selectedOperator='notdefined'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is not defined</xsl:text>
                    </option>
                </xsl:when>
                <xsl:when test="$fieldType='boolean'">
                    <option value="=">
                        <xsl:if test="$selectedOperator='='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is</xsl:text>
                    </option>
                </xsl:when>
                <xsl:when test="$fieldType='list' or $fieldType='systemList' or $fieldType='elementsList'">
                    <option value="=">
                        <xsl:if test="$selectedOperator='='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is</xsl:text>
                    </option>
                    <option value="NE">
                        <xsl:if test="$selectedOperator='NE'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is not</xsl:text>
                    </option>
                </xsl:when>
                <xsl:when test="$fieldType='dephits'">
                    <option value="none">
                        <xsl:if test="$selectedOperator='none'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is nil</xsl:text>
                    </option>
                    <option value="exist">
                        <xsl:if test="$selectedOperator='exist'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is at least 1</xsl:text>
                    </option>
                    <option value="=">
                        <xsl:if test="$selectedOperator='='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is equal to</xsl:text>
                    </option>
                    <option value="GT">
                        <xsl:if test="$selectedOperator='GT'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is greater than</xsl:text>
                    </option>
                    <option value="GT=">
                        <xsl:if test="$selectedOperator='GT='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is greater or equal to</xsl:text>
                    </option>
                    <option value="LT">
                        <xsl:if test="$selectedOperator='LT'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is lower than</xsl:text>
                    </option>
                    <option value="LT=">
                        <xsl:if test="$selectedOperator='LT='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is lower or equal to</xsl:text>
                    </option>
                </xsl:when>
                <xsl:otherwise>
                    <option value="contains">
                        <xsl:if test="$selectedOperator='contains'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>contains</xsl:text>
                    </option>
                    <option value="not contains">
                        <xsl:if test="$selectedOperator='not contains'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>does not contain</xsl:text>
                    </option>
                    <option value="=">
                        <xsl:if test="$selectedOperator='='">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is</xsl:text>
                    </option>
                    <option value="NE">
                        <xsl:if test="$selectedOperator='NE'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>is not</xsl:text>
                    </option>
                    <option value="starts-with">
                        <xsl:if test="$selectedOperator='starts-with'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>starts with</xsl:text>
                    </option>
                    <option value="ends-with">
                        <xsl:if test="$selectedOperator='ends-with'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>ends with</xsl:text>
                    </option>
                    <option value="IN">
                        <xsl:if test="$selectedOperator='IN'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>are equal to</xsl:text>
                    </option>
                    <option value="NOT IN">
                        <xsl:if test="$selectedOperator='NOT IN'">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>are not equal to</xsl:text>
                    </option>
                </xsl:otherwise>
            </xsl:choose>
        </select>
    </xsl:template>

    <!-- OPERANDS -->
    <xsl:template name="operands">
        <xsl:param name="lineID"/>        
        <xsl:param name="fieldType"/>
        <xsl:param name="list"/>
        <xsl:param name="elemsListFieldDenom"/>
        <xsl:param name="selectedOperator"/>
        <xsl:param name="operands"/>
        <xsl:param name="disableDateFormatting" select="0"/>

        <xsl:variable name="operand1ID" select="concat('search-operand1-', $lineID)"/>
        <xsl:variable name="operand2ID" select="concat('search-operand2-', $lineID)"/>

        <xsl:choose>
            <xsl:when test="$fieldType = 'list'">
				<xsl:variable name="operand1" select="$operands"/>

				<select id="{$operand1ID}" name="{$operand1ID}" class="search-operand1">
					<xsl:for-each select="$list/ITEM">
                        <xsl:sort select="@label"/>
						<option value="{@value}">
	                        <xsl:if test="$operand1=@value">
	                            <xsl:attribute name="selected">selected</xsl:attribute>
	                        </xsl:if>
							<xsl:value-of select="@label"/>
						</option>
					</xsl:for-each>
				</select>
            </xsl:when>
            <xsl:when test="$fieldType = 'systemList'">
				<xsl:variable name="operand1" select="$operands"/>

				<select id="{$operand1ID}" name="{$operand1ID}" class="search-operand1">
					<xsl:for-each select="$list/*">
                        <xsl:sort select="LABEL"/>
						<option value="{@ID}">
	                        <xsl:if test="$operand1=@ID">
	                            <xsl:attribute name="selected">selected</xsl:attribute>
	                        </xsl:if>
							<xsl:value-of select="LABEL"/>
						</option>
					</xsl:for-each>
				</select>
            </xsl:when>
            <xsl:when test="$fieldType = 'elementsList'">                
                <xsl:variable name="operand1" select="$operands"/>
                
				<select id="{$operand1ID}" name="{$operand1ID}" class="search-operand1">
					<xsl:for-each select="$list/*">
                        <xsl:sort select="INFO/*[name()=$elemsListFieldDenom]" order="ascending"/>

						<option value="{@ID}">
	                        <xsl:if test="$operand1=@ID">
	                            <xsl:attribute name="selected">selected</xsl:attribute>
	                        </xsl:if>
							<xsl:value-of select="INFO/*[name()=$elemsListFieldDenom]"/>
						</option>
					</xsl:for-each>
				</select>
            </xsl:when>
            <xsl:when test="$fieldType = 'boolean'">
                <xsl:variable name="operand1" select="$operands"/>

                <select id="{$operand1ID}" name="{$operand1ID}" class="search-operand1">
                    <option value="1">
                        <xsl:if test="$operand1=1">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>true</xsl:text>
                    </option>
                    <option value="0">
                        <xsl:if test="$operand1=0">
                            <xsl:attribute name="selected">selected</xsl:attribute>
                        </xsl:if>
                        <xsl:text>false</xsl:text>
                    </option>
                </select>
            </xsl:when>
           <xsl:when test="$fieldType = 'dephits'">
               <xsl:variable name="operand1" select="$operands"/>

	           	<xsl:choose>
	            	<xsl:when test="($selectedOperator='=') or ($selectedOperator='GT') or ($selectedOperator='GT=') or ($selectedOperator='LT') or ($selectedOperator='LT=')">
		                 <input type="text" id="{$operand1ID}" name="{$operand1ID}" class="search-operand1">
		                     <xsl:attribute name="value">
		                         <xsl:value-of select="$operand1"/>
		                     </xsl:attribute>
		                 </input>
	            	</xsl:when>
	            	<xsl:otherwise>
	            	</xsl:otherwise>
	           	</xsl:choose>
           </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$selectedOperator != 'between'">
                        <xsl:choose>
                            <xsl:when test="($fieldType='date') or ($fieldType='datetime')">
                                <!-- special operators which take no operands -->
                                <xsl:choose>
                                    <xsl:when test="$selectedOperator='today' or $selectedOperator='thisweek' or $selectedOperator='thismonth' or $selectedOperator='thisyear' or $selectedOperator='notdefined'">
                                    </xsl:when>
                                    <xsl:when test="$selectedOperator='since'">
                                        <xsl:variable name="operand1" select="substring-before(substring-after($operands,'today-'),' ')"/>
                                        <xsl:variable name="operand2" select="substring-before(substring-after($operands,concat($operand1,' ')),'/')"/>
                                        <input type="text" id="{$operand1ID}" name="{$operand1ID}" class="search-operand1" value="{$operand1}" />
                                        <select id="{$operand2ID}" name="{$operand2ID}" class="search-operand2" style="float:right;">
                                            <option value="days">
                                                <xsl:if test="$operand2='days'">
                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                </xsl:if>
                                                <xsl:text>day(s)</xsl:text>
                                            </option>
                                            <option value="months">
                                                <xsl:if test="$operand2='months'">
                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                </xsl:if>
                                                <xsl:text>month(s)</xsl:text>
                                            </option>
                                            <option value="years">
                                                <xsl:if test="$operand2='years'">
                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                </xsl:if>
                                                <xsl:text>year(s)</xsl:text>
                                            </option>
                                        </select>
                                    </xsl:when>
                                    <xsl:when test="$selectedOperator='forthenext'">
                                        <xsl:variable name="operand1" select="substring-before(substring-after($operands,'today+'),' ')"/>
                                        <xsl:variable name="operand2" select="substring-after($operands,concat($operand1,' '))"/>
                                        <input type="text" id="{$operand1ID}" name="{$operand1ID}" class="search-operand1" value="{$operand1}" />
                                        <select id="{$operand2ID}" name="{$operand2ID}" class="search-operand2" style="float:right;">
                                            <option value="days">
                                                <xsl:if test="$operand2='days'">
                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                </xsl:if>
                                                <xsl:text>day(s)</xsl:text>
                                            </option>
                                            <option value="months">
                                                <xsl:if test="$operand2='months'">
                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                </xsl:if>
                                                <xsl:text>month(s)</xsl:text>
                                            </option>
                                            <option value="years">
                                                <xsl:if test="$operand2='years'">
                                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                                </xsl:if>
                                                <xsl:text>year(s)</xsl:text>
                                            </option>
                                        </select>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:variable name="operand1">
                                            <xsl:choose>
                                                <xsl:when test="$disableDateFormatting=0">
                                                    <xsl:call-template name="format-date">
                                                        <xsl:with-param name="rawdate" select="$operands"/>
                                                    </xsl:call-template>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:value-of select="$operands"/>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:variable>

                                        <input type="text" id="{$operand1ID}" name="{$operand1ID}" class="search-operand1 isDatepicker">
                                            <xsl:attribute name="value">
                                                <xsl:value-of select="$operand1"/>
                                            </xsl:attribute>
                                        </input>
                                        <xsl:if test="$fieldType='datetime'">
								   		    <xsl:variable name="operand1IDhh" select="concat('search-operand1_hh-', $lineID)"/>
									        <xsl:variable name="operand1IDmm" select="concat('search-operand1_mm-', $lineID)"/>
									        <xsl:variable name="operand1IDss" select="concat('search-operand1_ss-', $lineID)"/>
						                    <input type="text" id="{$operand1IDhh}" name="{$operand1IDhh}" class="search-operand1_hh" value="{substring($operands,12,2)}" />
		           						    <span>:</span>
								            <input type="text" id="{$operand1IDmm}" name="{$operand1IDmm}" class="search-operand1_mm" value="{substring($operands,15,2)}" />
		           						    <span>:</span>
								            <input type="text" id="{$operand1IDss}" name="{$operand1IDss}" class="search-operand1_ss" value="{substring($operands,18,2)}" />
                                        </xsl:if>
                                        <xsl:if test="$lineID != ''">
                                            <script type="text/javascript">
                                                <xsl:call-template name="js-init-datepicker">
                                                    <xsl:with-param name="selector">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="$operand1ID"/>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </script>
                                        </xsl:if>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="operand1" select="$operands"/>

                                <input type="text" id="{$operand1ID}" name="{$operand1ID}" class="search-operand1">
                                    <xsl:attribute name="value">
                                        <xsl:value-of select="$operand1"/>
                                    </xsl:attribute>
                                </input>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:when test="$selectedOperator = 'between'">
                        <xsl:choose>
                            <xsl:when test="($fieldType='date') or ($fieldType='datetime')">
                                <xsl:variable name="rawoperand1" select="substring-before($operands, '/')"/>
                                <xsl:variable name="rawoperand2" select="substring-after($operands, '/')"/>
                                <xsl:variable name="operand1">
                                    <xsl:choose>
                                        <xsl:when test="$disableDateFormatting=0">
                                            <xsl:call-template name="format-date">
                                                <xsl:with-param name="rawdate" select="$rawoperand1"/>
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="$rawoperand1"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:variable>
                                <xsl:variable name="operand2">
                                    <xsl:choose>
                                        <xsl:when test="$disableDateFormatting=0">
                                            <xsl:call-template name="format-date">
                                                <xsl:with-param name="rawdate" select="$rawoperand2"/>
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="$rawoperand2"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:variable>

                                <input type="text" id="{$operand1ID}" name="{$operand1ID}" class="search-operand1 isDatepicker">
                                    <xsl:attribute name="value">
                                        <xsl:value-of select="$operand1"/>
                                    </xsl:attribute>
                                </input>
                                <xsl:if test="$fieldType='datetime'">
						   		    <xsl:variable name="operand1IDhh" select="concat('search-operand1_hh-', $lineID)"/>
							        <xsl:variable name="operand1IDmm" select="concat('search-operand1_mm-', $lineID)"/>
							        <xsl:variable name="operand1IDss" select="concat('search-operand1_ss-', $lineID)"/>
				                    <input type="text" id="{$operand1IDhh}" name="{$operand1IDhh}" class="search-operand1_hh" value="{substring($rawoperand1,12,2)}" />
           						    <span>:</span>
						            <input type="text" id="{$operand1IDmm}" name="{$operand1IDmm}" class="search-operand1_mm" value="{substring($rawoperand1,15,2)}" />
           						    <span>:</span>
						            <input type="text" id="{$operand1IDss}" name="{$operand1IDss}" class="search-operand1_ss" value="{substring($rawoperand1,18,2)}" />
                                </xsl:if>
                                <xsl:text> and</xsl:text>
                                <br/>
                                <input type="text" id="{$operand2ID}" name="{$operand2ID}" class="search-operand2 isDatepicker">
                                    <xsl:attribute name="value">
                                        <xsl:value-of select="$operand2"/>
                                    </xsl:attribute>
                                </input>
                                <xsl:if test="$fieldType='datetime'">
						   		    <xsl:variable name="operand2IDhh" select="concat('search-operand2_hh-', $lineID)"/>
							        <xsl:variable name="operand2IDmm" select="concat('search-operand2_mm-', $lineID)"/>
							        <xsl:variable name="operand2IDss" select="concat('search-operand2_ss-', $lineID)"/>
				                    <input type="text" id="{$operand2IDhh}" name="{$operand2IDhh}" class="search-operand2_hh" value="{substring($rawoperand2,12,2)}" />
           						    <span>:</span>
						            <input type="text" id="{$operand2IDmm}" name="{$operand2IDmm}" class="search-operand2_mm" value="{substring($rawoperand2,15,2)}" />
           						    <span>:</span>
						            <input type="text" id="{$operand2IDss}" name="{$operand2IDss}" class="search-operand2_ss" value="{substring($rawoperand2,18,2)}" />
                                </xsl:if>

                                <xsl:if test="$lineID != ''">
                                    <script type="text/javascript">
                                        <xsl:call-template name="js-init-datepicker">
                                            <xsl:with-param name="selector">
                                                <xsl:text>#</xsl:text><xsl:value-of select="$operand1ID"/>
                                            </xsl:with-param>
                                        </xsl:call-template>
                                        <xsl:call-template name="js-init-datepicker">
                                            <xsl:with-param name="selector">
                                                <xsl:text>#</xsl:text><xsl:value-of select="$operand2ID"/>
                                            </xsl:with-param>
                                        </xsl:call-template>
                                    </script>
                                </xsl:if>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:variable name="operand1" select="substring-before($operands, '/')"/>
                                <xsl:variable name="operand2" select="substring-after($operands, '/')"/>

                                <input type="text" id="{$operand1ID}" name="{$operand1ID}" class="search-operand1">
                                    <xsl:attribute name="value">
                                        <xsl:value-of select="$operand1"/>
                                    </xsl:attribute>
                                </input>
                                <xsl:text> and</xsl:text>
                                <br/>
                                <input type="text" id="{$operand2ID}" name="{$operand2ID}" class="search-operand2">
                                    <xsl:attribute name="value">
                                        <xsl:value-of select="$operand2"/>
                                    </xsl:attribute>
                                </input>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template> 
</xsl:stylesheet>